<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

/**
 * Class BackendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @SuppressWarnings(ExcessiveMethodLength)
 * @SuppressWarnings(ExcessiveClassLength)
 * @phpcs:disable
 */
class BackendStrings
{
    /**
     * Returns the array for the common strings
     *
     * @return array
     */
    public static function getCommonStrings()
    {
        return [
            'admin'                     => __('Admin', 'wpamelia'),
            'add_date'                  => __('Add Date', 'wpamelia'),
            'add_language'              => __('Add Language', 'wpamelia'),
            'all'                       => __('All', 'wpamelia'),
            'all_locations'             => __('All Locations', 'wpamelia'),
            'all_packages'              => __('All Packages', 'wpamelia'),
            'all_services'              => __('All Services', 'wpamelia'),
            'all_events'                => __('All events', 'wpamelia'),
            'appointment'               => __('Appointment', 'wpamelia'),
            'appointments'              => __('Appointments', 'wpamelia'),
            'approved'                  => __('Approved', 'wpamelia'),
            'apply_coupon'              => __('Apply Coupon:', 'wpamelia'),
            'booked'                    => __('Booked', 'wpamelia'),
            'cancel'                    => __('Cancel', 'wpamelia'),
            'canceled'                  => __('Canceled', 'wpamelia'),
            'canceled_by_admin'         => __('Canceled By Admin', 'wpamelia'),
            'canceled_by_attendee'      => __('Canceled By Attendee', 'wpamelia'),
            'capacity'                  => __('Spots', 'wpamelia'),
            'content_mode_tooltip'      => __('Don\'t use Text mode option if you already have HTML code in the description,<br>since once this option is enabled the existing HTML tags could be lost.', 'wpamelia'),
            'close'                     => __('Close', 'wpamelia'),
            'closed'                    => __('Closed', 'wpamelia'),
            'create'                    => __('Create', 'wpamelia'),
            'csv_delimiter'             => __('Select Delimiter', 'wpamelia'),
            'csv_delimiter_comma'       => __('Comma (,)', 'wpamelia'),
            'csv_delimiter_semicolon'   => __('Semicolon (;)', 'wpamelia'),
            'coupon'                    => __('Coupon', 'wpamelia'),
            'customer'                  => __('Customer', 'wpamelia'),
            'date_specific'             => __('Specific Date', 'wpamelia'),
            'minutes'                   => __('Minutes', 'wpamelia'),
            'hours'                     => __('Hours', 'wpamelia'),
            'day'                       => __('Day', 'wpamelia'),
            'days'                      => __('Days', 'wpamelia'),
            'week'                      => __('Week', 'wpamelia'),
            'weeks'                     => __('Weeks', 'wpamelia'),
            'month'                     => __('Month', 'wpamelia'),
            'months'                    => __('Months', 'wpamelia'),
            'year'                      => __('Year', 'wpamelia'),
            'years'                     => __('Years', 'wpamelia'),
            'date'                      => __('Date', 'wpamelia'),
            'delete'                    => __('Delete', 'wpamelia'),
            'description'               => __('Description', 'wpamelia'),
            'details'                   => __('Details', 'wpamelia'),
            'disabled'                  => __('Disabled', 'wpamelia'),
            'discard'                   => __('Discard', 'wpamelia'),
            'discount'                  => __('Discount (%)', 'wpamelia'),
            'duration'                  => __('Duration', 'wpamelia'),
            'duplicate'                 => __('Duplicate', 'wpamelia'),
            'edit'                      => __('Edit', 'wpamelia'),
            'email_placeholder'         => __('example@mail.com', 'wpamelia'),
            'employee'                  => __('Employee', 'wpamelia'),
            'employees'                 => __('Employees', 'wpamelia'),
            'enter_email_warning'       => __('Please enter email', 'wpamelia'),
            'enter_valid_email_warning' => __('Please enter a valid email address', 'wpamelia'),
            'error'                     => __('Error', 'wpamelia'),
            'event'                     => __('Event', 'wpamelia'),
            'events'                    => __('Events', 'wpamelia'),
            'export'                    => __('Export', 'wpamelia'),
            'extras'                    => __('Extras', 'wpamelia'),
            'google_calendar'           => __('Google Calendar', 'wpamelia'),
            'google_meet_join'          => __('Join With Google Meet', 'wpamelia'),
            'outlook_calendar'          => __('Outlook Calendar', 'wpamelia'),
            'h'                         => __('h', 'wpamelia'),
            'id'                        => __('ID', 'wpamelia'),
            'language'                  => __('Language', 'wpamelia'),
            'lesson_space'              => __('Lesson Space', 'wpamelia'),
            'appointment_space_name'    => __('Appointment Space Name', 'wpamelia'),
            'appointment_space_name_tt' => __('Name of the space(room) that will be created for appointments.<br/>You can find available placeholders on the Notifications page.<br/>If left empty, space will be named after appointment ID.'),
            'event_space_name'          => __('Event Space Name', 'wpamelia'),
            'event_space_name_tt'       => __('Name of the space(room) that will be created for events.<br/>You can find available placeholders on the Notifications page.<br/>If left empty, space will be named after event period ID.'),
            'lesson_space_join'         => __('Join Space', 'wpamelia'),
            'lesson_space_link'         => __('Lesson Space Link', 'wpamelia'),
            'lesson_space_pending'      => __('Create spaces for pending appointments', 'wpamelia'),
            'lesson_space_pending_tt'   => __('Enable this option if you want to create spaces for appointments with pending status.', 'wpamelia'),
            'location'                  => __('Location', 'wpamelia'),
            'locations'                 => __('Locations', 'wpamelia'),
            'min'                       => __('min', 'wpamelia'),
            'name'                      => __('Name', 'wpamelia'),
            'name_ascending'            => __('Name Ascending', 'wpamelia'),
            'name_descending'           => __('Name Descending', 'wpamelia'),
            'need_help'                 => __('Need Help', 'wpamelia'),
            'no'                        => __('No', 'wpamelia'),
            'no_employees_yet'          => __('You don\'t have any employees here yet...', 'wpamelia'),
            'no_results'                => __('There are no results...', 'wpamelia'),
            'no_packages_yet'           => __('You don\'t have any packages here yet...', 'wpamelia'),
            'no_services_yet'           => __('You don\'t have any services here yet...', 'wpamelia'),
            'note'                      => __('Note', 'wpamelia'),
            'note_internal'             => __('Note (Internal)', 'wpamelia'),
            'notifications'             => __('Notification', 'wpamelia'),
            'of'                        => __('of', 'wpamelia'),
            'ok'                        => __('OK', 'wpamelia'),
            'on_site'                   => __('On-site', 'wpamelia'),
            'on_site_tooltip'           => __('Here you can enable/disable On-Site payments for this service', 'wpamelia'),
            'open'                      => __('Open', 'wpamelia'),
            'opened'                    => __('Opened', 'wpamelia'),
            'out_of'                    => __('out of', 'wpamelia'),
            'package'                   => __('Package', 'wpamelia'),
            'packages'                  => __('Packages', 'wpamelia'),
            'package_price'             => __('Package Price', 'wpamelia'),
            'paid'                      => __('Paid', 'wpamelia'),
            'partially_paid'            => __('Partially Paid', 'wpamelia'),
            'payment'                   => __('Payment', 'wpamelia'),
            'payment_tooltip'           => __('Here you can select which payment methods will be available.<br/>If you disable all payment methods,<br/>then the default payment method from general settings will be used.', 'wpamelia'),
            'payment_warning'           => __('You have disabled all available payment methods. This means that default payment method from general settings will be used.', 'wpamelia'),
            'payment_warning_settings'  => __('Some services/events have all payment methods disabled. This means that default payment method will be used for those services/events.', 'wpamelia'),
            'payment_method'            => __('Payment Method', 'wpamelia'),
            'pending'                   => __('Pending', 'wpamelia'),
            'period'                    => __('Period', 'wpamelia'),
            'phone'                     => __('Phone', 'wpamelia'),
            'php_version_message'       => __('<p>The <strong>Amelia</strong> plugin requires PHP version 5.5 or greater.</p>', 'wpamelia'),
            'php_version_title'         => __('Plugin Activation Error', 'wpamelia'),
            'pick_a_date'               => __('Pick a date range', 'wpamelia'),
            'profile'                   => __('Hide Employee Profile', 'wpamelia'),
            'recurring'                 => __('Recurring', 'wpamelia'),
            'recurring_type_daily'      => __('Daily', 'wpamelia'),
            'recurring_type_monthly'    => __('Monthly', 'wpamelia'),
            'recurring_type_weekly'     => __('Weekly', 'wpamelia'),
            'recurring_type_yearly'     => __('Yearly', 'wpamelia'),
            'rejected'                  => __('Rejected', 'wpamelia'),
            'rescheduled'               => __('Rescheduled', 'wpamelia'),
            'package_appointments'      => __('Package Appointments', 'wpamelia'),
            'save'                      => __('Save', 'wpamelia'),
            'recurring_every'           => __('Every:', 'wpamelia'),
            'schedule'                  => __('Schedule', 'wpamelia'),
            'select_date_warning'       => __('Please select date', 'wpamelia'),
            'select_cycle_warning'      => __('Please select repeat period', 'wpamelia'),
            'select_interval_warning'   => __('Please select repeat interval', 'wpamelia'),
            'select_time'               => __('Select Time', 'wpamelia'),
            'select_time_warning'       => __('Please select time', 'wpamelia'),
            'service'                   => __('Service', 'wpamelia'),
            'services'                  => __('Services', 'wpamelia'),
            'settings_saved'            => __('Settings has been saved', 'wpamelia'),
            'showing'                   => __('Showing', 'wpamelia'),
            'sort'                      => __('Sort', 'wpamelia'),
            'status'                    => __('Status', 'wpamelia'),
            'status_colon'              => __('Status:', 'wpamelia'),
            'success'                   => __('Success', 'wpamelia'),
            'text_mode'                 => __('Text Mode', 'wpamelia'),
            'html_mode'                 => __('HTML Mode', 'wpamelia'),
            'to'                        => __('to', 'wpamelia'),
            'today'                     => __('Today', 'wpamelia'),
            'tomorrow'                  => __('Tomorrow', 'wpamelia'),
            'total'                     => __('Total', 'wpamelia'),
            'translate'                 => __('Translate', 'wpamelia'),
            'translation'               => __('Translation', 'wpamelia'),
            'view'                      => __('View', 'wpamelia'),
            'weekday_friday'            => __('Friday', 'wpamelia'),
            'weekday_monday'            => __('Monday', 'wpamelia'),
            'weekday_saturday'          => __('Saturday', 'wpamelia'),
            'weekday_sunday'            => __('Sunday', 'wpamelia'),
            'weekday_thursday'          => __('Thursday', 'wpamelia'),
            'weekday_tuesday'           => __('Tuesday', 'wpamelia'),
            'weekday_wednesday'         => __('Wednesday', 'wpamelia'),
            'yes'                       => __('Yes', 'wpamelia'),
            'zoom'                      => __('Zoom', 'wpamelia'),
            'zoom_click_to_join'        => __('Join Zoom Meeting', 'wpamelia'),
            'zoom_click_to_start'       => __('Start Zoom Meeting', 'wpamelia'),
            'zoom_join_link'            => __('Zoom Join Link (Participants)', 'wpamelia'),
            'zoom_start_link'           => __('Zoom Start Link (Host)', 'wpamelia'),
            'zoom_user'                 => __('Zoom User', 'wpamelia'),
            'zoom_user_placeholder'     => __('Select Zoom User', 'wpamelia'),
            'zoom_warning'              => __('Certain employees that are assigned to the service are not connected to Zoom users. Please go to employees\' profiles and connect them to Zoom users in order to use this integration properly.', 'wpamelia'),
            'unlimited'                 => __('Unlimited', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the settings strings
     *
     * @return array
     */
    public static function getSettingsStrings()
    {
        return [
            'activate'                               => __('Activate', 'wpamelia'),
            'activation'                             => __('Activation', 'wpamelia'),
            'activation_activated'                   => __('Plugin has been activated', 'wpamelia'),
            'activation_deactivated'                 => __('Plugin has been deactivated', 'wpamelia'),
            'activation_envato_failed'               => __('It seems that Envato API is currently busy (please try again) or you don\'t have a valid purchase of Amelia', 'wpamelia'),
            'activation_settings'                    => __('Activation Settings', 'wpamelia'),
            'activation_settings_description'        => __('Use this setting to activate the plugin code so you can have access to auto updates of Amelia', 'wpamelia'),
            'activation_settings_domains_limit'      => __('You have reached maximum number of registered domains', 'wpamelia'),
            'activation_settings_explanation'        => __('Activate the plugin by entering Purchase code or using Envato API.', 'wpamelia'),
            'activation_settings_invalid_code'       => __('The purchase code is invalid or it has expired', 'wpamelia'),
            'activation_settings_hidden_code'        => __('Your purchase code has been hidden for security reasons. You can find it on your store page', 'wpamelia'),
            'add_metaData'                           => __('Add New MetaData'),
            'add_new_role'                           => __('Add New Role', 'wpamelia'),
            'add_web_hook'                           => __('Add New Web Hook', 'wpamelia'),
            'add_to_calendar'                        => __('Show Add To Calendar option to customers', 'wpamelia'),
            'add_to_calendar_tooltip'                => __('Suggest customers to add an appointment to their calendar<br/>when booking is finalized.', 'wpamelia'),
            'address'                                => __('Address', 'wpamelia'),
            'after'                                  => __('After', 'wpamelia'),
            'after_with_space'                       => __('After with space', 'wpamelia'),
            'allow_booking_if_not_min'               => __('Allow booking below minimum capacity', 'wpamelia'),
            'allow_admin_book_at_any_time'           => __('Allow admin to book appointment at any time', 'wpamelia'),
            'allow_admin_book_at_any_time_tooltip'   => __('If you enable this option, Admin will be able to book appointment at any time<br>(working hours, special days and days off for all employees will be ignored).', 'wpamelia'),
            'allow_configure_days_off'               => __('Configure their days off', 'wpamelia'),
            'allow_configure_services'               => __('Configure their services', 'wpamelia'),
            'allow_configure_schedule'               => __('Configure their schedule', 'wpamelia'),
            'allow_configure_special_days'           => __('Configure their special days', 'wpamelia'),
            'allow_booking_if_pending'               => __('Allow booking above maximum capacity', 'wpamelia'),
            'allow_booking_if_pending_tooltip'       => __('If this is disabled, your front-end customers won\'t be able to book appointment with Pending status above the maximum capacity.<br/>Once the maximum capacity is reached appointment will close and time slot will become unavailable.', 'wpamelia'),
            'allow_booking_if_not_min_tooltip'       => __('If this is disabled, your front-end customers won\'t be able to submit a booking unless they fill in the minimum service capacity,<br/>but once they book for any capacity above minimum, the time slot will become unavailable for booking for others.<br/>If enabled, multiple customers will be able to book the same time slot, without having to fill in the minimum capacity.', 'wpamelia'),
            'allow_customer_reschedule'              => __('Allow customers to reschedule their own appointments', 'wpamelia'),
            'allow_customer_reschedule_tooltip'      => __('Enable this option if you want to allow your customers to reschedule their own appointments.', 'wpamelia'),
            'allow_customer_delete_profile'          => __('Allow customers to delete their profile', 'wpamelia'),
            'allow_customer_delete_profile_tooltip'  => __('Enable this option if you want to allow your customers to delete their profile data (bookings won\'t be deleted).', 'wpamelia'),
            'allow_write_appointments'               => __('Manage their appointments', 'wpamelia'),
            'allow_write_events'                     => __('Manage their events', 'wpamelia'),
            'amelia_role'                            => __('Amelia Role', 'wpamelia'),
            'appointments'                           => __('Appointments', 'wpamelia'),
            'appointments_settings'                  => __('Appointments Settings', 'wpamelia'),
            'appointments_settings_description'      => __('Use these settings to manage frontend bookings', 'wpamelia'),
            'automatically_create_customer'          => __('Automatically create Amelia Customer user', 'wpamelia'),
            'automatically_create_customer_tooltip'  => __('If you enable this option every time a new customer schedules the appointment<br/>he will get Amelia Customer user role and automatic email with login details.', 'wpamelia'),
            'bcc_email'                              => __('Send all notifications to additional addresses', 'wpamelia'),
            'bcc_email_placeholder'                  => __('Please enter email address', 'wpamelia'),
            'bcc_email_tooltip'                      => __('Here you can enter additional email addresses where all notifications will be sent.<br/>To add an address click Enter.', 'wpamelia'),
            'bcc_sms'                                => __('Send all SMS messages to additional numbers', 'wpamelia'),
            'bcc_sms_placeholder'                    => __('Please enter phone number', 'wpamelia'),
            'bcc_sms_tooltip'                        => __('Here you can enter additional phone numbers where all SMS messages will be sent.<br/>To add a number click Enter.', 'wpamelia'),
            'before'                                 => __('Before', 'wpamelia'),
            'before_with_space'                      => __('Before with space', 'wpamelia'),
            'buffer_time_in_slot'                    => __('Include service buffer time in time slots', 'wpamelia'),
            'buffer_time_in_slot_tooltip'            => __('If this option is enabled<br>time slots will be shown with included service buffer time', 'wpamelia'),
            'calendar'                               => __('Calendar', 'wpamelia'),
            'cancel_error_url'                       => __('Unsuccessful Cancellation Redirect URL', 'wpamelia'),
            'cancel_error_url_tooltip'               => __('URL on which will user be redirected if appointment can\'t be canceled<br/>because of \'Minimum time required before canceling\' value', 'wpamelia'),
            'cancel_success_url'                     => __('Successful Cancellation Redirect URL', 'wpamelia'),
            'cancel_url_placeholder'                 => __('Please enter URL', 'wpamelia'),
            'codecanyon_purchase_code'               => __('CodeCanyon Purchase Code', 'wpamelia'),
            'comma_dot'                              => __('Comma-Dot', 'wpamelia'),
            'company'                                => __('Company', 'wpamelia'),
            'company_settings'                       => __('Company Settings', 'wpamelia'),
            'company_settings_description'           => __('Use these settings to set up picture, name, address, phone and website of your company', 'wpamelia'),
            'coupons'                                => __('Coupons', 'wpamelia'),
            'enable_google_meet'                     => __('Enable Google Meet', 'wpamelia'),
            'facebook_pixel'                         => __('Facebook Pixel', 'wpamelia'),
            'facebook_pixel_event_tooltip'           => __('Name of the pixel event (standard or custom)', 'wpamelia'),
            'google_analytics'                       => __('Google Analytics', 'wpamelia'),
            'enable_google_meet_tooltip'             => __('Enable this option if you want to include Google Meet in your event.', 'wpamelia'),
            'currency'                               => __('Currency', 'wpamelia'),
            'custom_fields'                          => __('Custom Fields', 'wpamelia'),
            'custom_fields_description'              => __('Add/edit custom fields', 'wpamelia'),
            'custom_fields_settings'                 => __('Custom fields settings', 'wpamelia'),
            'customers_as_attendees'                 => __('Add Event\'s Attendees', 'wpamelia'),
            'customers_as_attendees_tooltip'         => __('Enable this option if you want your employees to see<br/>in the event customers that attend the appointment.', 'wpamelia'),
            'customer_cabinet'                       => __('Customer Panel Page URL', 'wpamelia'),
            'employee_cabinet'                       => __('Employee Panel Page URL', 'wpamelia'),
            'customer_cabinet_tooltip'               => __('Enter here URL of the page with [ameliacustomerpanel] shortcode if you want to send it to your customers in notifications.<br/>Make sure to also add the placeholder in notification so the URL can be sent.', 'wpamelia'),
            'employee_cabinet_tooltip'               => __('Enter here URL of the page with [ameliaemployeepanel] shortcode if you want to send it to your employees in notifications.<br/>Make sure to also add the placeholder in notification so the URL can be sent.', 'wpamelia'),
            'dashboard'                              => __('Dashboard', 'wpamelia'),
            'day1'                                   => __('1 day', 'wpamelia'),
            'days2'                                  => __('2 days', 'wpamelia'),
            'days3'                                  => __('3 days', 'wpamelia'),
            'days4'                                  => __('4 days', 'wpamelia'),
            'days5'                                  => __('5 days', 'wpamelia'),
            'days6'                                  => __('6 days', 'wpamelia'),
            'days_off_settings'                      => __('Days Off Settings', 'wpamelia'),
            'days_off_settings_description'          => __('Use these settings to set company working hours and days off which will be applied for every employee', 'wpamelia'),
            'deactivate'                             => __('Deactivate', 'wpamelia'),
            'default_appointment_status'             => __('Default Appointment Status', 'wpamelia'),
            'default_appointment_status_tooltip'     => __('All appointments will be scheduled with the<br/>status you choose here.', 'wpamelia'),
            'default_items_per_page'                 => __('Default items per page', 'wpamelia'),
            'default_page_on_backend'                => __('Default page on back-end', 'wpamelia'),
            'default_payment_method'                 => __('Default Payment Method', 'wpamelia'),
            'default_phone_country_code'             => __('Default phone country code', 'wpamelia'),
            'default_time_slot_step'                 => __('Default Time Slot Step', 'wpamelia'),
            'default_time_slot_step_tooltip'         => __('The Time Slot Step you define here will be applied<br/>for all time slots in the plugin.', 'wpamelia'),
            'delete_tables'                          => __('Delete plugin tables', 'wpamelia'),
            'delete_tables_tooltip'                  => __('Enable this option if you want to delete plugin tables<br>when deleting the plugin from plugins page', 'wpamelia'),
            'description_mollie'                     => __('Description for Mollie', 'wpamelia'),
            'description_paypal'                     => __('Description for PayPal', 'wpamelia'),
            'description_stripe'                     => __('Description for Stripe', 'wpamelia'),
            'description_wc'                         => __('Description for WooCommerce', 'wpamelia'),
            'dot_comma'                              => __('Dot-Comma', 'wpamelia'),
            'enable_labels_settings'                 => __('Enable Labels Settings', 'wpamelia'),
            'enable_labels_settings_tooltip'         => __('Disable this option if you want to translate these<br/>strings using the third party translation plugin.', 'wpamelia'),
            'enable_customer_cabinet'                => __('Enable Customer Panel', 'wpamelia'),
            'enable_employee_cabinet'                => __('Enable Employee Panel', 'wpamelia'),
            'enabled'                                => __('Enabled', 'wpamelia'),
            'endpoint'                               => __('Endpoint', 'wpamelia'),
            'endpoint_tooltip'                       => __('Enter here an endpoint if you are using Mailgun from EU countries', 'wpamelia'),
            'enter_valid_url_warning'                => __('Please enter a valid URL with protocol (http:// or https://)', 'wpamelia'),
            'envato_api'                             => __('Envato API', 'wpamelia'),
            'envato_api_activate'                    => __('Activate with Envato', 'wpamelia'),
            'envato_api_activated'                   => __('Activated with Envato', 'wpamelia'),
            'events'                                 => __('Events', 'wpamelia'),
            'event_description'                      => __('Event Description', 'wpamelia'),
            'event_description_tooltip'              => __('Description of the event that will be displayed in the Google Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'event_description_tooltip_outlook'      => __('Description of the event that will be displayed in the Outlook Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'event_title'                            => __('Event Title', 'wpamelia'),
            'event_title_tooltip'                    => __('Title of the event that will be displayed in the Google Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'event_title_tooltip_outlook'            => __('Title of the event that will be displayed in the Outlook Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'meeting_title'                          => __('Meeting Title', 'wpamelia'),
            'meeting_title_tooltip'                  => __('Title of the meeting that will be displayed in the Zoom.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'meeting_agenda'                         => __('Meeting Agenda', 'wpamelia'),
            'meeting_agenda_tooltip'                 => __('Agenda of the meeting that will be displayed in the Zoom.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'general'                                => __('General', 'wpamelia'),
            'general_settings'                       => __('General Settings', 'wpamelia'),
            'general_settings_description'           => __('Use these settings to define plugin general settings and default settings for your services and appointments', 'wpamelia'),
            'gMap_api_key'                           => __('Google Map API Key', 'wpamelia'),
            'gMap_api_key_tooltip'                   => __('Add Google Map API Key to show Google static map on<br/>"Locations" page.', 'wpamelia'),
            'google_calendar_settings'               => __('Google Calendar Settings', 'wpamelia'),
            'google_calendar_settings_description'   => __("Allow synchronizing employee's calendar with Google Calendar for smoother personal scheduling", 'wpamelia'),
            'zoom_settings'                          => __('Zoom Settings', 'wpamelia'),
            'google_client_id'                       => __('Client ID', 'wpamelia'),
            'google_client_secret'                   => __('Client Secret', 'wpamelia'),
            'outlook_client_id'                      => __('Application (client) ID', 'wpamelia'),
            'outlook_client_secret'                  => __('Client Secret', 'wpamelia'),
            'google_credentials_obtain'              => __('Click here to see how to obtain<br/>Google Client ID and Secret', 'wpamelia'),
            'outlook_credentials_obtain'             => __('Click here to see how to obtain<br/>Outlook Application (client) ID and Secret', 'wpamelia'),
            'marketing_add_tracking'                 => __('Add Tracking', 'wpamelia'),
            'marketing_field_warning'                => __('Please fill out this field.', 'wpamelia'),
            'google_analytics_category'              => __('Category', 'wpamelia'),
            'facebook_pixel_event'                   => __('Event', 'wpamelia'),
            'google_analytics_action'                => __('Action', 'wpamelia'),
            'google_analytics_label'                 => __('Label', 'wpamelia'),
            'google_analytics_value'                 => __('Value', 'wpamelia'),
            'marketing_type_warning'                 => __('Please select type.', 'wpamelia'),
            'marketing_delete_confirmation'          => __('Are you sure you want to delete this Event', 'wpamelia'),
            'google_redirect_uri'                    => __('Redirect URI', 'wpamelia'),
            'google_redirect_uri_tooltip'            => __('This is the path in your application that users are redirected to after<br/>they have authenticated with Google. Add this URI in your Google<br/>project credentials under "Authorized redirect URIs".', 'wpamelia'),
            'outlook_redirect_uri'                   => __('Redirect URI', 'wpamelia'),
            'outlook_redirect_uri_tooltip'           => __('This is the path in your application that users are redirected to after<br/>they have authenticated with Outlook. Add this URI in your Outlook<br/>application under "Redirect URIs".', 'wpamelia'),
            'zoom_api_key'                           => __('Client Key', 'wpamelia'),
            'zoom_api_secret'                        => __('Client Secret', 'wpamelia'),
            'zoom_credentials_obtain'                => __('Click here to see how to obtain<br/>Zoom API Key and Secret', 'wpamelia'),
            'lesson_space_api_key'                   => __('Lesson Space API Key', 'wpamelia'),
            'integrations_settings'                  => __('Integrations', 'wpamelia'),
            'integrations_settings_description'      => __("Manage Google Calendar Integration, Outlook Calendar Integration, Zoom Integration and Web Hooks", 'wpamelia'),
            'h1'                                     => __('1h', 'wpamelia'),
            'h10'                                    => __('10h', 'wpamelia'),
            'h11'                                    => __('11h', 'wpamelia'),
            'h12'                                    => __('12h', 'wpamelia'),
            'h1min30'                                => __('1h 30min', 'wpamelia'),
            'h2'                                     => __('2h', 'wpamelia'),
            'h3'                                     => __('3h', 'wpamelia'),
            'h4'                                     => __('4h', 'wpamelia'),
            'h6'                                     => __('6h', 'wpamelia'),
            'h8'                                     => __('8h', 'wpamelia'),
            'h9'                                     => __('9h', 'wpamelia'),
            'identify_country_code'                  => __('Identify country code by user\'s IP address', 'wpamelia'),
            'insert_pending_appointments'            => __('Insert Pending Appointments', 'wpamelia'),
            'insert_pending_appointments_tooltip'    => __('Enable this option if you want your employees to see<br/>appointments with pending status in their calendar.', 'wpamelia'),
            'pending_appointments_meetings'          => __('Create Meetings For Pending Appointments', 'wpamelia'),
            'pending_appointments_meetings_tooltip'  => __('Enable this option if you want to create zoom meetings for appointments with pending status.', 'wpamelia'),
            'inspect_customer_info'                  => __('Check customer\'s name for existing email when booking', 'wpamelia'),
            'inspect_customer_info_tooltip'          => __('Enable this option if you don\'t want to allow "existing customer"<br/>to use different first and last name when booking.', 'wpamelia'),
            'instructions'                           => __('Instructions', 'wpamelia'),
            'label_employee'                         => __('Employee', 'wpamelia'),
            'label_employees'                        => __('Employees', 'wpamelia'),
            'label_service'                          => __('Service', 'wpamelia'),
            'label_services'                         => __('Services', 'wpamelia'),
            'labels'                                 => __('Labels', 'wpamelia'),
            'labels_settings'                        => __('Labels Settings', 'wpamelia'),
            'labels_settings_description'            => __('Use these settings to change labels on frontend pages', 'wpamelia'),
            'labels_settings_web_hooks'              => __('Use these settings to register URLs to which booking information will be sent when booking action occurs.', 'wpamelia'),
            'limit_number_of_fetched_events'         => __('Limit Number of Fetched Events', 'wpamelia'),
            'live_api_key'                           => __('Live API Key', 'wpamelia'),
            'live_client_id'                         => __('Live Client ID', 'wpamelia'),
            'live_publishable_key'                   => __('Live Publishable Key', 'wpamelia'),
            'live_secret'                            => __('Live Secret', 'wpamelia'),
            'live_secret_key'                        => __('Live Secret Key', 'wpamelia'),
            'mail_service'                           => __('Mail Service', 'wpamelia'),
            'mailgun'                                => __('Mailgun', 'wpamelia'),
            'mailgun_api_key'                        => __('Mailgun API Key', 'wpamelia'),
            'mailgun_api_key_warning'                => __('Please enter Mailgun API key', 'wpamelia'),
            'mailgun_domain'                         => __('Mailgun Domain', 'wpamelia'),
            'mailgun_domain_warning'                 => __('Please enter Mailgun Domain', 'wpamelia'),
            'manage_languages'                       => __('Manage languages', 'wpamelia'),
            'manage_languages_tooltip'               => __('Here you can define languages that you want to have in the plugin<br>for translating dynamic strings (names, descriptions, notifications).', 'wpamelia'),
            'marketing_tools'                        => __('Marketing Tools', 'wpamelia'),
            'metadata_value_tooltip'                 => __('You can find available placeholders on the Notifications page', 'wpamelia'),
            'min1'                                   => __('1min', 'wpamelia'),
            'min10'                                  => __('10min', 'wpamelia'),
            'min12'                                  => __('12min', 'wpamelia'),
            'min15'                                  => __('15min', 'wpamelia'),
            'min2'                                   => __('2min', 'wpamelia'),
            'min20'                                  => __('20min', 'wpamelia'),
            'min30'                                  => __('30min', 'wpamelia'),
            'min45'                                  => __('45min', 'wpamelia'),
            'min5'                                   => __('5min', 'wpamelia'),
            'minimum_time_before_booking'            => __('Minimum time required before booking', 'wpamelia'),
            'minimum_time_before_booking_tooltip'    => __('Set the time before the appointment when customers<br/>will not be able to book the appointment.', 'wpamelia'),
            'minimum_time_before_canceling'          => __('Minimum time required before canceling', 'wpamelia'),
            'minimum_time_before_canceling_tooltip'  => __('Set the time before the appointment when customers<br/>will not be able to cancel the appointment.', 'wpamelia'),
            'minimum_time_before_rescheduling'       => __('Minimum time required before rescheduling', 'wpamelia'),
            'minimum_time_before_rescheduling_tooltip'  => __('Set the time before the appointment when customers<br/>will not be able to reschedule the appointment.', 'wpamelia'),
            'mollie'                                 => __('Mollie', 'wpamelia'),
            'mollie_service'                         => __('Mollie Service', 'wpamelia'),
            'mollie_test_api_key_error'              => __('Please enter test API Key', 'wpamelia'),
            'mollie_live_api_key_error'              => __('Please enter live API Key', 'wpamelia'),
            'months3'                                => __('3 months', 'wpamelia'),
            'months6'                                => __('6 months', 'wpamelia'),
            'name'                                   => __('Name', 'wpamelia'),
            'notifications_settings'                 => __('Notification Settings', 'wpamelia'),
            'notifications_settings_description'     => __('Use these settings to set your mail settings which will be used to notify your customers and employees', 'wpamelia'),
            'notify_customers_default'               => __('Notify the customer(s) by default', 'wpamelia'),
            'number_of_events_returned'              => __('Maximum Number Of Events Returned', 'wpamelia'),
            'number_of_events_returned_tooltip'      => __('Maximum number of events returned on one result page.<br/>It is recommended to use smaller number of returned<br/>events if your server performance is not so good.', 'wpamelia'),
            'payments'                               => __('Payments', 'wpamelia'),
            'payments_settings'                      => __('Payments Settings', 'wpamelia'),
            'payments_settings_description'          => __('Use these settings to set price format, payment method and coupons that will be used in all bookings', 'wpamelia'),
            'payPal'                                 => __('PayPal', 'wpamelia'),
            'payPal_live_client_id_error'            => __('Please enter live ClientId', 'wpamelia'),
            'payPal_live_secret_error'               => __('Please enter live Secret', 'wpamelia'),
            'payPal_service'                         => __('PayPal Service', 'wpamelia'),
            'payPal_test_client_id_error'            => __('Please enter test ClientId', 'wpamelia'),
            'payPal_test_secret_error'               => __('Please enter test Secret', 'wpamelia'),
            'period_available_for_booking'           => __('Period available for booking in advance', 'wpamelia'),
            'period_available_for_booking_tooltip'   => __('Set how far customers can book.', 'wpamelia'),
            'php_mail'                               => __('PHP Mail', 'wpamelia'),
            'plugin_not_activated'                   => __('To receive automatic updates license activation is required. Please visit %s to activate Amelia.', 'wpamelia'),
            'price_number_of_decimals'               => __('Price Number Of Decimals', 'wpamelia'),
            'price_separator'                        => __('Price Separator', 'wpamelia'),
            'price_symbol_position'                  => __('Price Symbol Position', 'wpamelia'),
            'purchase_code'                          => __('Purchase code', 'wpamelia'),
            'recaptcha_enabled'                      => __('Enable Google reCAPTCHA', 'wpamelia'),
            'recaptcha_enabled_tooltip'              => __('Enable this option if you want to add Google reCAPTCHA on the front-end booking forms', 'wpamelia'),
            'recaptcha_invisible'                    => __('Add "Invisible Google reCaptcha"', 'wpamelia'),
            'recaptcha_invisible_tooltip'            => __('If you enable this option Google reCAPTCHA will stay visible in the bottom right corner<br>but the plugin will check the user automatically, without the need to mark the checkbox.', 'wpamelia'),
            'recaptcha_site_key'                     => __('Google reCAPTCHA Site Key', 'wpamelia'),
            'recaptcha_site_key_tooltip'             => __('Paste here the Site Key that you have got once you have signed up for the API key pair on Google reCAPTCHA.', 'wpamelia'),
            'recaptcha_secret'                       => __('Google reCAPTCHA Secret Key', 'wpamelia'),
            'recaptcha_secret_tooltip'               => __('Paste here the Secret Key that you have got once you have signed up for the API key pair on Google reCAPTCHA.', 'wpamelia'),
            'recaptcha_site_key_error'               => __('Please enter site key', 'wpamelia'),
            'recaptcha_secret_error'                 => __('Please enter secret', 'wpamelia'),
            'redirect_url_after_appointment'         => __('Redirect URL After Booking', 'wpamelia'),
            'redirect_url_after_appointment_tooltip' => __('Customer will be redirected to this URL once he schedules the appointment.', 'wpamelia'),
            'remove_google_busy_slots'               => __('Remove Google Calendar Busy Slots', 'wpamelia'),
            'remove_google_busy_slots_tooltip'       => __('Enable this option if you want to remove busy slots in<br/>Google Calendar from Employee\'s working schedule.', 'wpamelia'),
            'remove_outlook_busy_slots'              => __('Remove Outlook Calendar Busy Slots', 'wpamelia'),
            'remove_outlook_busy_slots_tooltip'      => __('Enable this option if you want to remove busy slots in<br/>Outlook Calendar from Employee\'s working schedule.', 'wpamelia'),
            'include_buffer_time_google'             => __('Include Buffer time in Google events', 'wpamelia'),
            'include_buffer_time_google_tooltip'     => __('If you disable this option buffer time for scheduled appointments<br/>will not be added to the Google Calendar events.', 'wpamelia'),
            'include_buffer_time_outlook'            => __('Include Buffer time in Outlook events', 'wpamelia'),
            'include_buffer_time_outlook_tooltip'    => __('If you disable this option buffer time for scheduled appointments<br/>will not be added to the Outlook Calendar events.', 'wpamelia'),
            'package_placeholders'                   => __('Package placeholders', 'wpamelia'),
            'package_placeholders_tooltip'           => __('Placeholders for package appointments that will be sent in email.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'recurring_placeholders'                 => __('Recurring placeholders', 'wpamelia'),
            'recurring_placeholders_tooltip'         => __('Placeholders for recurring appointments that will be sent in email.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'require_cabinet_password'               => __('Require password for login', 'wpamelia'),
            'require_cabinet_password_tooltip'       => __('If you disable this option, your customers will be able to access customer panel with link that is sent to their email account.', 'wpamelia'),
            'required_email_field'                   => __('Set email as a mandatory field', 'wpamelia'),
            'required_phone_number_field'            => __('Set a phone number as a mandatory field', 'wpamelia'),
            'rest_api_clientid'                      => __('Rest App Client ID', 'wpamelia'),
            'rest_api_secret'                        => __('Rest App Secret', 'wpamelia'),
            'roles_settings'                         => __('Roles Settings', 'wpamelia'),
            'roles_settings_description'             => __('Use these settings to define settings that will be applied for the specific Amelia roles', 'wpamelia'),
            'sandbox_mode'                           => __('Sandbox Mode', 'wpamelia'),
            'send_event_invitation_email'            => __('Send Event Invitation Email', 'wpamelia'),
            'send_event_invitation_email_tooltip'    => __('Enable this option if you want your customers to<br/>receive an email about the event.', 'wpamelia'),
            'send_ics_attachment'                    => __('Send ics file in the notifications', 'wpamelia'),
            'send_ics_attachment_tooltip'            => __('Enable this option if you want to send ics file in email after booking.', 'wpamelia'),
            'sender_email'                           => __('Sender Email', 'wpamelia'),
            'sender_email_warning'                   => __('Please enter sender email', 'wpamelia'),
            'sender_name'                            => __('Sender Name', 'wpamelia'),
            'sender_name_warning'                    => __('Please enter sender name', 'wpamelia'),
            'service_duration_as_slot'               => __('Use service duration for booking a time slot', 'wpamelia'),
            'service_duration_as_slot_tooltip'       => __('Enable this option if you want to make time slot step<br/>the same as service duration in the booking process', 'wpamelia'),
            'set_metaData_and_description'           => __('Set MetaData and Description'),
            'settings'                               => __('Settings', 'wpamelia'),
            'settings_lower'                         => __('settings', 'wpamelia'),
            'show_attendees'                         => __('Allow customers to see other attendees', 'wpamelia'),
            'show_attendees_tooltip'                 => __('Enable this option if you want your customers to see<br/>all attendees in the appointment in their google calendar.', 'wpamelia'),
            'show_client_time_zone'                  => __('Show booking slots in client time zone', 'wpamelia'),
            'show_client_time_zone_tooltip'          => __('Enable this option if you want to show booking slots<br/>in client time zone.', 'wpamelia'),
            'smtp'                                   => __('SMTP', 'wpamelia'),
            'smtp_host'                              => __('SMTP Host', 'wpamelia'),
            'smtp_host_warning'                      => __('Please enter SMTP host', 'wpamelia'),
            'smtp_password'                          => __('SMTP Password', 'wpamelia'),
            'smtp_password_warning'                  => __('Please enter SMTP password', 'wpamelia'),
            'smtp_port'                              => __('SMTP Port', 'wpamelia'),
            'smtp_port_warning'                      => __('Please enter SMTP port', 'wpamelia'),
            'smtp_secure'                            => __('SMTP Secure', 'wpamelia'),
            'smtp_secure_disabled'                   => __('Disabled', 'wpamelia'),
            'smtp_secure_ssl'                        => __('SSL', 'wpamelia'),
            'smtp_secure_tls'                        => __('TLS', 'wpamelia'),
            'smtp_username'                          => __('SMTP Username', 'wpamelia'),
            'smtp_username_warning'                  => __('Please enter SMTP username', 'wpamelia'),
            'space_comma'                            => __('Space-Comma', 'wpamelia'),
            'space_dot'                              => __('Space-Dot', 'wpamelia'),
            'stash_entities'                         => __('Load Entities on page load', 'wpamelia'),
            'stash_entities_tooltip'                 => __('Enable this option if you want to avoid AJAX calls<br>for fetching entities (services, employees, locations, packages, tags)', 'wpamelia'),
            'stripe'                                 => __('Stripe', 'wpamelia'),
            'stripe_live_publishable_key_error'      => __('Please enter live publishable key', 'wpamelia'),
            'stripe_live_secret_key_error'           => __('Please enter live secret key', 'wpamelia'),
            'stripe_service'                         => __('Stripe Service', 'wpamelia'),
            'stripe_ssl_warning'                     => __('SSL (HTTPS) is not enabled. You will not be able to process live Stripe transactions until SSL is enabled.', 'wpamelia'),
            'outlook_ssl_warning'                    => __('SSL (HTTPS) is not enabled. You will not be able to use Outlook Calendar integration until SSL is enabled.', 'wpamelia'),
            'stripe_test_publishable_key_error'      => __('Please enter test publishable key', 'wpamelia'),
            'stripe_test_secret_key_error'           => __('Please enter test secret key', 'wpamelia'),
            'template_for_event_title'               => __('Template for Event Title', 'wpamelia'),
            'test_api_key'                           => __('Test API Key', 'wpamelia'),
            'test_client_id'                         => __('Test Client ID', 'wpamelia'),
            'test_mode'                              => __('Test Mode', 'wpamelia'),
            'test_publishable_key'                   => __('Test Publishable Key', 'wpamelia'),
            'test_secret'                            => __('Test Secret', 'wpamelia'),
            'test_secret_key'                        => __('Test Secret Key', 'wpamelia'),
            'tracking_ViewContent'                   => __('Load Page', 'wpamelia'),
            'tracking_SelectCategory'                => __('Select Category', 'wpamelia'),
            'tracking_SelectService'                 => __('Select Service', 'wpamelia'),
            'tracking_SelectEmployee'                => __('Select Employee', 'wpamelia'),
            'tracking_SelectLocation'                => __('Select Location', 'wpamelia'),
            'tracking_SelectPackage'                 => __('Select Package', 'wpamelia'),
            'tracking_SelectEvent'                   => __('Select Event', 'wpamelia'),
            'tracking_Purchase'                      => __('Complete Booking With Payment', 'wpamelia'),
            'tracking_Schedule'                      => __('Complete Booking Without Payment', 'wpamelia'),
            'tracking_InitiateCheckout'              => __('Show Checkout Form', 'wpamelia'),
            'tracking_type_tooltip'                  => __('Select action on which event will be called', 'wpamelia'),
            'tracking_parameter_name'                => __('Property Name', 'wpamelia'),
            'tracking_parameter_name_tooltip'        => __('Name of the property (standard or custom) for pixel event', 'wpamelia'),
            'tracking_parameter_value'               => __('Property Value', 'wpamelia'),
            'two_way_sync'                           => __('2 Way Sync', 'wpamelia'),
            'unable_to_deactivate_plugin'            => __('Unable to deactivate plugin. Please try again later.', 'wpamelia'),
            'update_for_all'                         => __('Update for all', 'wpamelia'),
            'url'                                    => __('URL', 'wpamelia'),
            'custom_fields_upload_path'              => __('Attachment upload path', 'wpamelia'),
            'custom_fields_upload_path_tooltip'      => __('If you leave this field empty, all attachments will be uploaded into the Wordpress uploads folder.', 'wpamelia'),
            'value'                                  => __('Value', 'wpamelia'),
            'view_activation_settings'               => __('View Activation Settings', 'wpamelia'),
            'view_appointments_settings'             => __('View Appointments Settings', 'wpamelia'),
            'view_company_settings'                  => __('View Company Settings', 'wpamelia'),
            'view_days_off_settings'                 => __('View Working Hours & Days Off Settings', 'wpamelia'),
            'view_general_settings'                  => __('View General Settings', 'wpamelia'),
            'view_google_calendar_settings'          => __('View Google Calendar Settings', 'wpamelia'),
            'view_integrations_settings'             => __('View Integrations Settings', 'wpamelia'),
            'view_labels_settings'                   => __('View Labels Settings', 'wpamelia'),
            'view_notifications_settings'            => __('View Notifications Settings', 'wpamelia'),
            'view_payments_settings'                 => __('View Payments Settings', 'wpamelia'),
            'view_roles_settings_description'        => __('View Roles Settings', 'wpamelia'),
            'view_web_hooks_settings'                => __('View Web Hooks Settings', 'wpamelia'),
            'wc'                                     => __('Enable integration with WooCommerce', 'wpamelia'),
            'wc_product'                             => __('Select WooCommerce product', 'wpamelia'),
            'wc_product_tooltip'                     => __('Here you can choose the product that will be used for WooCommerce integration.', 'wpamelia'),
            'wc_service'                             => __('WooCommerce Service', 'wpamelia'),
            'wc_on_site_if_free'                     => __('Hide WooCommerce cart when price is 0', 'wpamelia'),
            'website'                                => __('Website', 'wpamelia'),
            'web_hooks'                              => __('Web Hooks', 'wpamelia'),
            'web_hooks_settings'                     => __('Web Hooks Settings', 'wpamelia'),
            'web_hook_delete_confirmation'           => __('Are you sure you want to delete this web hook', 'wpamelia'),
            'web_hook_action'                        => __('Action', 'wpamelia'),
            'web_hook_action_warning'                => __('Please select action', 'wpamelia'),
            'web_hook_name_warning'                  => __('Please enter name', 'wpamelia'),
            'web_hook_booking_type'                  => __('Type', 'wpamelia'),
            'web_hook_booking_type_warning'          => __('Please enter booking type', 'wpamelia'),
            'web_hook_booking_completed'             => __('Booking Completed', 'wpamelia'),
            'web_hook_booking_rescheduled'           => __('Booking Rescheduled', 'wpamelia'),
            'web_hook_booking_canceled'              => __('Booking Canceled', 'wpamelia'),
            'web_hook_booking_status_updated'        => __('Booking Status Changed', 'wpamelia'),
            'week1'                                  => __('1 week', 'wpamelia'),
            'weeks2'                                 => __('2 weeks', 'wpamelia'),
            'weeks3'                                 => __('3 weeks', 'wpamelia'),
            'weeks4'                                 => __('4 weeks', 'wpamelia'),
            'work_hours_days_off'                    => __('Working Hours & Days Off', 'wpamelia'),
            'wp_mail'                                => __('WP Mail', 'wpamelia'),
            'wp_role'                                => __('WP Role', 'wpamelia'),
            'hide_currency_symbol_frontend'          => __('Hide Currency Symbol on the booking form', 'wpamelia'),
            'custom_currency_symbol'                 => __('Custom Currency Symbol', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the email notifications strings
     *
     * @return array
     */
    public static function getNotificationsStrings()
    {
        return [
            'accepted'                               => __('Accepted', 'wpamelia'),
            'after'                                  => __('After', 'wpamelia'),
            'already_have_an_account'                => __('Already have an account?', 'wpamelia'),
            'amelia_sms'                             => __('Amelia SMS', 'wpamelia'),
            'amount_colon'                           => __('Amount:', 'wpamelia'),
            'balance_colon'                          => __('Balance:', 'wpamelia'),
            'balance_recharged'                      => __('Your balance has been recharged', 'wpamelia'),
            'before'                                 => __('Before', 'wpamelia'),
            'cant_checkout'                          => __('This payment cannot be completed', 'wpamelia'),
            'cant_recharge_balance'                  => __('This payment cannot be completed and your account has not been charged', 'wpamelia'),
            'carrier'                                => __('Carrier:', 'wpamelia'),
            'change_alpha_sender_id'                 => __('Change Alpha Sender ID', 'wpamelia'),
            'change_password'                        => __('Change Password', 'wpamelia'),
            'choose_when'                            => __('Choose when', 'wpamelia'),
            'configure_placeholder'                  => __('Configure placeholder', 'wpamelia'),
            'configure_placeholder_here'             => __('Configure placeholder here', 'wpamelia'),
            'cost_colon'                             => __('Cost:', 'wpamelia'),
            'create_notification'                    => __('Create New Notification', 'wpamelia'),
            'cron_instruction'                       => __('To send this notification please add the following line in your cron', 'wpamelia'),
            'current_password_colon'                 => __('Current Password:', 'wpamelia'),
            'current_password_requred'               => __('Please enter current password', 'wpamelia'),
            'custom_amount'                          => __('Custom Amount', 'wpamelia'),
            'custom_notification'                    => __('Custom Notification', 'wpamelia'),
            'customer_appointment_approved'          => __('Appointment Approved', 'wpamelia'),
            'customer_appointment_canceled'          => __('Appointment Canceled', 'wpamelia'),
            'customer_appointment_follow_up'         => __('Appointment Follow Up', 'wpamelia'),
            'customer_appointment_next_day_reminder' => __('Appointment Next Day Reminder', 'wpamelia'),
            'customer_appointment_pending'           => __('Appointment Pending', 'wpamelia'),
            'customer_appointment_rejected'          => __('Appointment Rejected', 'wpamelia'),
            'customer_appointment_rescheduled'       => __('Appointment Rescheduled', 'wpamelia'),
            'customer_account_recovery'              => __('Customer Panel Access', 'wpamelia'),
            'customer_birthday_greeting'             => __('Birthday Greeting', 'wpamelia'),
            'customer_event_approved'                => __('Event Booked', 'wpamelia'),
            'customer_event_canceled'                => __('Event Canceled By Attendee', 'wpamelia'),
            'customer_event_follow_up'               => __('Event Follow Up', 'wpamelia'),
            'customer_event_next_day_reminder'       => __('Event Next Day Reminder', 'wpamelia'),
            'customer_event_rejected'                => __('Event Canceled By Admin', 'wpamelia'),
            'customer_event_rescheduled'             => __('Event Rescheduled', 'wpamelia'),
            'customer_other_notifications'           => __('Other', 'wpamelia'),
            'provider_other_notifications'           => __('Other', 'wpamelia'),
            'customer_package_canceled'              => __('Package Canceled', 'wpamelia'),
            'customer_package_purchased'             => __('Package Purchased', 'wpamelia'),
            'customize_sms'                          => __('Customize SMS', 'wpamelia'),
            'date_colon'                             => __('Date:', 'wpamelia'),
            'default_content_customer'               => __('Dear <b>%customer_full_name%</b>, <br><br>Thank you for choosing our company, <br> <b>%company_name%</b>'),
            'default_content_customer_sms'           => __('Dear %customer_full_name%, 
            
Thank you for choosing our company, 
%company_name%'),
            'default_content_employee'               => __('Hi <b>%employee_full_name%</b>, <br><br>Thank you, <br> <b>%company_name%</b>'),
            'default_content_employee_sms'           => __('Hi %employee_full_name%, 
            
Thank you, 
%company_name%'),
            'delivered'                              => __('Delivered', 'wpamelia'),
            'delete_message'                         => __('Are you sure you want to delete this notification? <br> You can\'t undo this action', 'wpamelia'),
            'dont_have_an_account'                   => __('Don\'t have an account?', 'wpamelia'),
            'duplicate_of'                           => __('Duplicate of ', 'wpamelia'),
            'edit_notification'                      => __('Edit Notification', 'wpamelia'),
            'email'                                  => __('Email', 'wpamelia'),
            'email_colon'                            => __('Email:', 'wpamelia'),
            'email_notifications'                    => __('Email Notifications', 'wpamelia'),
            'email_placeholders'                     => __('Email Placeholders', 'wpamelia'),
            'email_taken'                            => __('This email address is already being used', 'wpamelia'),
            'enter_name_warning'                     => __('Please enter name', 'wpamelia'),
            'enter_number'                           => __('Enter number', 'wpamelia'),
            'enter_password_warning'                 => __('Please enter password', 'wpamelia'),
            'enter_recipient_email_warning'          => __('Please enter recipient email', 'wpamelia'),
            'enter_recipient_phone_warning'          => __('Please enter recipient phone', 'wpamelia'),
            'enter_valid_email_warning'              => __('Please enter a valid email address', 'wpamelia'),
            'enter_valid_phone_warning'              => __('Please enter a valid phone number', 'wpamelia'),
            'failed'                                 => __('Failed', 'wpamelia'),
            'forgot_password'                        => __('Forgot Password?', 'wpamelia'),
            'incorrect_email'                        => __('You have entered an incorrect email', 'wpamelia'),
            'incorrect_password'                     => __('You have entered an incorrect password', 'wpamelia'),
            'insert_email_placeholders'              => __('Insert email placeholders', 'wpamelia'),
            'insert_email_placeholders_tooltip'      => __('Choose one of the placeholders from the lists below, click on it to copy and then paste into the template.', 'wpamelia'),
            'invalid_token'                          => __('Invalid Token', 'wpamelia'),
            'loading'                                => __('Loading...', 'wpamelia'),
            'logout'                                 => __('Logout', 'wpamelia'),
            'manage_languages'                       => __('Manage languages', 'wpamelia'),
            'message_colon'                          => __('Message:', 'wpamelia'),
            'messages_lower'                         => __('messages', 'wpamelia'),
            'new_password_colon'                     => __('New Password:', 'wpamelia'),
            'new_password_requred'                   => __('Please enter new password', 'wpamelia'),
            'no_messages'                            => __('There are no SMS messages...', 'wpamelia'),
            'notification_enabled'                   => __('Notification is enabled', 'wpamelia'),
            'notification_name'                      => __('Notification name', 'wpamelia'),
            'notification_name_enter'                => __('Enter notification name', 'wpamelia'),
            'notification_not_saved'                 => __('Notification has not been saved', 'wpamelia'),
            'notification_saved'                     => __('Notification has been saved', 'wpamelia'),
            'notification_not_deleted'               => __('Notification has not been deleted', 'wpamelia'),
            'notification_deleted'                   => __('Notification has been deleted', 'wpamelia'),
            'notification_scheduled'                 => __('Scheduled notification', 'wpamelia'),
            'notification_appointment_status'        => __('Appointment status', 'wpamelia'),
            'notification_event_action'              => __('Event action', 'wpamelia'),
            'notification_template'                  => __('Notification Template', 'wpamelia'),
            'notification_triggered'                 => __('Action triggered notification', 'wpamelia'),
            'notification_type'                      => __('Notification Type', 'wpamelia'),
            'notifications'                          => __('Notifications', 'wpamelia'),
            'package_placeholder_label'              => __('Package Appointments List', 'wpamelia'),
            'paddle'                                 => __('Paddle', 'wpamelia'),
            'password'                               => __('Password', 'wpamelia'),
            'password_colon'                         => __('Password:', 'wpamelia'),
            'password_has_been_changed'              => __('Password has been changed', 'wpamelia'),
            'password_length'                        => __('Password must have a length between 5 and 40 characters', 'wpamelia'),
            'password_reset_success'                 => __('Your password has been reset successfully', 'wpamelia'),
            'password_whitespace'                    => __('Password must not contain whitespace', 'wpamelia'),
            'passwords_do_not_match'                 => __('Passwords do not match', 'wpamelia'),
            'payment_history'                        => __('Payment History', 'wpamelia'),
            'payment_history_error'                  => __('Unable to retrieve payments results', 'wpamelia'),
            'payment_id'                             => __('Payment ID', 'wpamelia'),
            'payment_id_colon'                       => __('Payment ID:', 'wpamelia'),
            'payments_lower'                         => __('payments', 'wpamelia'),
            'payPal'                                 => __('PayPal', 'wpamelia'),
            'ph_appointment_cancel_url'              => __('Cancel Appointment Link', 'wpamelia'),
            'ph_appointment_date'                    => __('Date of the appointment', 'wpamelia'),
            'ph_appointment_date_time'               => __('Date & Time of the appointment', 'wpamelia'),
            'ph_appointment_duration'                => __('Duration of the appointment', 'wpamelia'),
            'ph_appointment_end_time'                => __('End time of the appointment', 'wpamelia'),
            'ph_appointment_id'                      => __('Id of the appointment', 'wpamelia'),
            'ph_appointment_notes'                   => __('Appointment notes', 'wpamelia'),
            'ph_appointment_price'                   => __('Appointment price', 'wpamelia'),
            'ph_appointment_deposit_payment'         => __('Appointment deposit', 'wpamelia'),
            'ph_appointment_status'                  => __('Status of the appointment', 'wpamelia'),
            'ph_appointment_start_time'              => __('Start time of the appointment', 'wpamelia'),
            'ph_attendee_code'                       => __('Attendee code', 'wpamelia'),
            'ph_booked_customer'                     => __('Booked Customer (full name, email, phone)', 'wpamelia'),
            'ph_booking_number_of_persons'           => __('Number of persons', 'wpamelia'),
            'ph_category_name'                       => __('Category name', 'wpamelia'),
            'ph_company_address'                     => __('Company address', 'wpamelia'),
            'ph_company_name'                        => __('Company name', 'wpamelia'),
            'ph_company_phone'                       => __('Company phone', 'wpamelia'),
            'ph_company_website'                     => __('Company website', 'wpamelia'),
            'ph_coupon_used'                         => __('Used Coupon', 'wpamelia'),
            'ph_customer_cabinet_url'                => __('Customer Panel Access Link', 'wpamelia'),
            'ph_customer_email'                      => __('Customer email', 'wpamelia'),
            'ph_employee_cabinet_url'                => __('Employee Panel Access Link', 'wpamelia'),
            'ph_customer_first_name'                 => __('Customer first name', 'wpamelia'),
            'ph_customer_full_name'                  => __('Customer full name', 'wpamelia'),
            'ph_customer_last_name'                  => __('Customer last name', 'wpamelia'),
            'ph_customer_note'                       => __('Customer note', 'wpamelia'),
            'ph_customer_phone'                      => __('Customer phone', 'wpamelia'),
            'ph_employee_email'                      => __('Employee email', 'wpamelia'),
            'ph_employee_first_name'                 => __('Employee first name', 'wpamelia'),
            'ph_employee_full_name'                  => __('Employee full name', 'wpamelia'),
            'ph_employee_last_name'                  => __('Employee last name', 'wpamelia'),
            'ph_employee_name_email_phone'           => __('Employee name, email & phone', 'wpamelia'),
            'ph_employee_note'                       => __('Employee note', 'wpamelia'),
            'ph_employee_phone'                      => __('Employee phone', 'wpamelia'),
            'ph_employee_photo'                      => __('Employee photo', 'wpamelia'),
            'ph_event_cancel_url'                    => __('Cancel Event Link', 'wpamelia'),
            'ph_event_description'                   => __('Event description', 'wpamelia'),
            'ph_event_end_date'                      => __('End date of the event', 'wpamelia'),
            'ph_event_end_date_time'                 => __('End date & time of the event', 'wpamelia'),
            'ph_event_end_time'                      => __('End time of the event', 'wpamelia'),
            'ph_event_name'                          => __('Event name', 'wpamelia'),
            'ph_event_period_date'                   => __('Date period of the event', 'wpamelia'),
            'ph_event_period_date_time'              => __('Date & Time period of the event', 'wpamelia'),
            'ph_event_price'                         => __('Event price', 'wpamelia'),
            'ph_event_deposit_payment'               => __('Event deposit', 'wpamelia'),
            'ph_event_start_date'                    => __('Start date of the event', 'wpamelia'),
            'ph_event_start_date_time'               => __('Start date & time of the event', 'wpamelia'),
            'ph_event_start_time'                    => __('Start time of the event', 'wpamelia'),
            'ph_extras'                              => __('Selected extras', 'wpamelia'),
            'ph_lesson_space_url'                    => __('Lesson space link to join space', 'wpamelia'),
            'ph_lesson_space_url_date'               => __('Date periods of the event with Lesson Space join links', 'wpamelia'),
            'ph_lesson_space_url_date_time'          => __('Date & Time periods of the event with Lesson Space join links', 'wpamelia'),
            'ph_location_address'                    => __('Location address', 'wpamelia'),
            'ph_location_description'                => __('Location description', 'wpamelia'),
            'ph_location_name'                       => __('Location name', 'wpamelia'),
            'ph_location_phone'                      => __('Location phone', 'wpamelia'),
            'ph_package_appointments_details'        => __('Package appointments details', 'wpamelia'),
            'ph_package_name'                        => __('Package name', 'wpamelia'),
            'ph_package_description'                 => __('Package description', 'wpamelia'),
            'ph_package_details_setup'               => __('Package appointments list placeholder set up', 'wpamelia'),
            'ph_package_duration'                    => __('Package duration', 'wpamelia'),
            'ph_package_price'                       => __('Package price description', 'wpamelia'),
            'ph_package_deposit_payment'             => __('Package deposit', 'wpamelia'),
            'ph_payment_price'                       => __('Payment price', 'wpamelia'),
            'ph_package_tooltip'                     => __('Set what details you want to send to your customers/employees about their packages.', 'wpamelia'),
            'ph_recurring_appointments_details'      => __('Recurring appointments details', 'wpamelia'),
            'ph_recurring_details_setup'             => __('Recurring appointments details placeholder set up', 'wpamelia'),
            'ph_recurring_tooltip'                   => __('Set what details you want to send to your customers/employees about their recurring appointments.', 'wpamelia'),
            'ph_reservation_description'             => __('Service or Event description', 'wpamelia'),
            'ph_reservation_name'                    => __('Service or Event name', 'wpamelia'),
            'ph_service_description'                 => __('Service description', 'wpamelia'),
            'ph_service_duration'                    => __('Service duration', 'wpamelia'),
            'ph_service_name'                        => __('Service name', 'wpamelia'),
            'ph_service_price'                       => __('Service price', 'wpamelia'),
            'ph_time_zone'                           => __('Time Zone', 'wpamelia'),
            'ph_zoom_host_url'                       => __('Zoom Start Meeting (Hosts) Link', 'wpamelia'),
            'ph_zoom_host_url_date'                  => __('Date periods of the event with Zoom start links', 'wpamelia'),
            'ph_zoom_host_url_date_date'             => __('Date & Time periods of the event with Zoom start links', 'wpamelia'),
            'ph_zoom_join_url'                       => __('Zoom Join Meeting (Participants) Link', 'wpamelia'),
            'ph_zoom_join_url_date'                  => __('Date periods of the event with Zoom join links', 'wpamelia'),
            'ph_zoom_join_url_date_date'             => __('Date & Time periods of the event with Zoom join links', 'wpamelia'),
            'ph_google_meet_url'                     => __('Google Meet Join Link', 'wpamelia'),
            'phone_colon'                            => __('Phone:', 'wpamelia'),
            'companyPlaceholders'                    => __('Company', 'wpamelia'),
            'customerPlaceholders'                   => __('Customer', 'wpamelia'),
            'packagePlaceholders'                    => __('Package', 'wpamelia'),
            'employeePlaceholders'                   => __('Employee', 'wpamelia'),
            'categoryPlaceholders'                   => __('Category', 'wpamelia'),
            'locationPlaceholders'                   => __('Location', 'wpamelia'),
            'appointmentPlaceholders'                => __('Appointment', 'wpamelia'),
            'eventPlaceholders'                      => __('Event', 'wpamelia'),
            'customFieldsPlaceholders'               => __('Custom fields', 'wpamelia'),
            'extrasPlaceholders'                     => __('Extra', 'wpamelia'),
            'couponsPlaceholders'                    => __('Coupon', 'wpamelia'),
            'placeholders'                           => __('Placeholders', 'wpamelia'),
            'placeholder_copied'                     => __('Placeholder Copied', 'wpamelia'),
            'prepared'                               => __('Prepared', 'wpamelia'),
            'price'                                  => __('Price', 'wpamelia'),
            'pricing'                                => __('Pricing', 'wpamelia'),
            'pricing_error'                          => __('Unable to retrieve pricing', 'wpamelia'),
            'provider_appointment_approved'          => __('Appointment Approved', 'wpamelia'),
            'provider_appointment_canceled'          => __('Appointment Canceled', 'wpamelia'),
            'provider_appointment_next_day_reminder' => __('Appointment Next Day Reminder', 'wpamelia'),
            'provider_package_canceled'              => __('Package Canceled', 'wpamelia'),
            'provider_package_purchased'             => __('Package Purchased', 'wpamelia'),
            'provider_panel_access'                  => __('Employee Panel Access', 'wpamelia'),
            'provider_panel_recovery'                => __('Employee Panel Recovery', 'wpamelia'),
            'provider_appointment_pending'           => __('Appointment Pending', 'wpamelia'),
            'provider_appointment_rejected'          => __('Appointment Rejected', 'wpamelia'),
            'provider_appointment_rescheduled'       => __('Appointment Rescheduled', 'wpamelia'),
            'provider_event_approved'                => __('Event Booked', 'wpamelia'),
            'provider_event_canceled'                => __('Event Canceled By Attendee', 'wpamelia'),
            'provider_event_next_day_reminder'       => __('Event Next Day Reminder', 'wpamelia'),
            'provider_event_rejected'                => __('Event Canceled By Admin', 'wpamelia'),
            'provider_event_rescheduled'             => __('Event Rescheduled', 'wpamelia'),
            'queued'                                 => __('Queued', 'wpamelia'),
            're_type_requred'                        => __('Please enter new password again', 'wpamelia'),
            'recharge'                               => __('Recharge', 'wpamelia'),
            'recharge_balance'                       => __('Recharge Balance', 'wpamelia'),
            'recharge_custom_amount'                 => __('Recharge Custom Amount', 'wpamelia'),
            'recipient_email'                        => __('Recipient Email', 'wpamelia'),
            'recipient_phone'                        => __('Recipient Phone', 'wpamelia'),
            'recipients'                             => __('Recipients', 'wpamelia'),
            'recovery_email_sent'                    => __('Account recovery email has been sent', 'wpamelia'),
            'recurring_ph_warning'                   => __('Once set, this placeholder applies to all types of notifications where it is added', 'wpamelia'),
            'refresh'                                => __('Refresh', 'wpamelia'),
            'requires_scheduling_setup'              => __('Requires Scheduling Setup', 'wpamelia'),
            'reset_password'                         => __('Reset Password', 'wpamelia'),
            'retype_new_password_colon'              => __('Re-type New Password:', 'wpamelia'),
            'same_day'                               => __('On the same day', 'wpamelia'),
            'scheduled_after_appointment'            => __('Scheduled After Appointment', 'wpamelia'),
            'scheduled_after_event'                  => __('Scheduled After Event', 'wpamelia'),
            'scheduled_before'                       => __('Scheduled For Before Appointment', 'wpamelia'),
            'scheduled_for'                          => __('Scheduled For', 'wpamelia'),
            'security'                               => __('Security', 'wpamelia'),
            'segments_colon'                         => __('Segments:', 'wpamelia'),
            'select_email_template_warning'          => __('Please select email template', 'wpamelia'),
            'send'                                   => __('Send', 'wpamelia'),
            'send_only_this'                         => __('Send only this notification', 'wpamelia'),
            'send_only_this_tooltip'                 => __('If this is selected the default notification will not be sent for the selected services', 'wpamelia'),
            'send_only_this_tooltip_event'           => __('If this is selected the default notification will not be sent for the selected events', 'wpamelia'),
            'send_recovery_email'                    => __('Send Recovery Email', 'wpamelia'),
            'send_test_email'                        => __('Send Test Email', 'wpamelia'),
            'send_test_sms'                          => __('Send Test SMS', 'wpamelia'),
            'sender_id_colon'                        => __('Alpha Sender ID:', 'wpamelia'),
            'sender_id_invalid_characters_error'     => __('Special characters are not allowed', 'wpamelia'),
            'sender_id_length_error'                 => __('Sender ID supports up to 11 characters', 'wpamelia'),
            'sender_id_letter_error'                 => __('Your ID must include at least one letter', 'wpamelia'),
            'sender_id_required'                     => __('Alpha Sender ID can\'t be empty', 'wpamelia'),
            'sender_id_saved'                        => __('Alpha Sender ID has been saved', 'wpamelia'),
            'sent'                                   => __('Sent', 'wpamelia'),
            'show_email_codes'                       => __('</> Show Email Placeholders', 'wpamelia'),
            'show_sms_codes'                         => __('</> Show SMS Placeholders', 'wpamelia'),
            'sign_in'                                => __('Sign In', 'wpamelia'),
            'sign_up'                                => __('Sign Up', 'wpamelia'),
            'sms_history'                            => __('SMS History', 'wpamelia'),
            'sms_notifications'                      => __('SMS Notifications', 'wpamelia'),
            'sms_placeholders'                       => __('SMS Placeholders', 'wpamelia'),
            'sms_vat_apply'                          => __('If you are from a country where VAT or GST applies, a VAT/GST charge will be added to the transaction.', 'wpamelia'),
            'status_colon'                           => __('Status:', 'wpamelia'),
            'subject'                                => __('Subject', 'wpamelia'),
            'test_email_error'                       => __('Email has not been sent', 'wpamelia'),
            'test_email_success'                     => __('Email has been sent', 'wpamelia'),
            'test_email_warning'                     => __('To be able to send test email please configure "Sender Email" in Notification Settings.', 'wpamelia'),
            'test_sms_error'                         => __('SMS has not been sent', 'wpamelia'),
            'test_sms_success'                       => __('SMS has been sent', 'wpamelia'),
            'test_sms_warning'                       => __('To be able to send test SMS please recharge your balance.', 'wpamelia'),
            'text_colon'                             => __('Text:', 'wpamelia'),
            'time'                                   => __('Time', 'wpamelia'),
            'time_colon'                             => __('Time:', 'wpamelia'),
            'to_customer'                            => __('To Customer', 'wpamelia'),
            'to_employee'                            => __('To Employee', 'wpamelia'),
            'token_expired'                          => __('Token has been expired', 'wpamelia'),
            'type'                                   => __('Type', 'wpamelia'),
            'type_colon'                             => __('Type:', 'wpamelia'),
            'undelivered'                            => __('Undelivered', 'wpamelia'),
            'user_colon'                             => __('User:', 'wpamelia'),
            'user_profile'                           => __('User Profile', 'wpamelia'),
            'use_placeholder'                        => __('Use placeholder:', 'wpamelia'),
            'view_message'                           => __('View Message', 'wpamelia'),
            'view_pricing_for'                       => __('View pricing for:', 'wpamelia'),
            'view_profile'                           => __('View Profile', 'wpamelia'),
        ];
    }


    /**
     * Returns the array for the common strings
     *
     * @return array
     */
    public static function getDashboardStrings()
    {
        return [
            'appointments_count'            => __('# of appointments', 'wpamelia'),
            'appointments_revenue'          => __('Sum of payments', 'wpamelia'),
            'appointments_hours'            => __('# of Hours in appointment', 'wpamelia'),
            'appointments_load'             => __('% of load', 'wpamelia'),
            'approved_appointments'         => __('Approved Appointments', 'wpamelia'),
            'approved_appointments_tooltip' => __('Indicates the number of approved appointments<br/>for a chosen date range.', 'wpamelia'),
            'average_bookings'              => __('Average Bookings', 'wpamelia'),
            'average_bookings_tooltip'      => __('Shows the average number of bookings per day<br/>for the selected date range.', 'wpamelia'),
            'conversions'                   => __('Interests / Conversions', 'wpamelia'),
            'conversions_tooltip'           => __('Shows the number of views for the employee/service/location<br/>vs. the number of times they were booked during<br/>the selected date range.', 'wpamelia'),
            'customers_tooltip'             => __('Indicates the number of new and returning customers<br/>for the selected date range.', 'wpamelia'),
            'dashboard'                     => __('Dashboard', 'wpamelia'),
            'new'                           => __('New', 'wpamelia'),
            'no_today_appointments'         => __('There are no appointments for today', 'wpamelia'),
            'no_upcoming_appointments'      => __('You don\'t have any upcoming appointments yet', 'wpamelia'),
            'packages_purchased_count'      => __('Times bought', 'wpamelia'),
            'pending_appointments'          => __('Pending Appointments', 'wpamelia'),
            'pending_appointments_tooltip'  => __('Shows the number of pending appointments<br/>in the selected date range.', 'wpamelia'),
            'percentage_of_load'            => __('Percentage of Load', 'wpamelia'),
            'percentage_of_load_tooltip'    => __('Indicates the percentage of occupied time against available time for appointments<br/>in the chosen date range.', 'wpamelia'),
            'returning'                     => __('Returning', 'wpamelia'),
            'revenue'                       => __('Revenue', 'wpamelia'),
            'revenue_tooltip'               => __('Shows the total income for paid appointments<br/>in the chosen date range.', 'wpamelia'),
            'time'                          => __('Time', 'wpamelia'),
            'today_appointments'            => __('Today\'s appointments', 'wpamelia'),
            'views'                         => __('Views', 'wpamelia'),
            'hello_message_part0'           => __('Hello', 'wpamelia'),
            'hello_message_part1'           => __('You have', 'wpamelia'),
            'hello_message_part2'           => __('and', 'wpamelia'),
            'hello_message_part3'           => __('for today', 'wpamelia'),
            'upcoming_appointments'         => __('Upcoming appointments', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the schedule modal
     *
     * @return array
     */
    public static function getScheduleStrings()
    {
        return [
            'add_break'                           => __('Add Break', 'wpamelia'),
            'add_day_off'                         => __('Add Day Off', 'wpamelia'),
            'add_day_off_placeholder'             => __('Enter holiday or day off name', 'wpamelia'),
            'add_period'                          => __('Add Period', 'wpamelia'),
            'add_special_day'                     => __('Add Special Day', 'wpamelia'),
            'apply_to_all_days'                   => __('Apply to All Days', 'wpamelia'),
            'breaks'                              => __('Breaks', 'wpamelia'),
            'company_days_off'                    => __('Company Days off', 'wpamelia'),
            'company_days_off_settings'           => __('Company Days Off Settings', 'wpamelia'),
            'company_work_hours_settings'         => __('Company Working Hours Settings', 'wpamelia'),
            'confirm_global_change_working_hours' => __('You will change working hours setting which is also set for each employee separately. Do you want to update it for all employees?', 'wpamelia'),
            'day_off_name'                        => __('Day Off name', 'wpamelia'),
            'days_off'                            => __('Days Off', 'wpamelia'),
            'days_off_add'                        => __('Add Day Off', 'wpamelia'),
            'days_off_date_warning'               => __('Please enter date', 'wpamelia'),
            'days_off_name_warning'               => __('Please enter name', 'wpamelia'),
            'days_off_repeat_yearly'              => __('Repeat Yearly', 'wpamelia'),
            'edit_company_days_off'               => __('Edit Company Days off', 'wpamelia'),
            'employee_days_off'                   => __('Employee Days off', 'wpamelia'),
            'once_off'                            => __('Once Off', 'wpamelia'),
            'pick_a_date_or_range'                => __('Pick a date or range', 'wpamelia'),
            'pick_a_year'                         => __('Pick a year', 'wpamelia'),
            'reflects_on'                         => __('Reflects on', 'wpamelia'),
            'repeat_every_year'                   => __('Repeat Every Year', 'wpamelia'),
            'save_special_day'                    => __('Save Special Day', 'wpamelia'),
            'set_break_time'                      => __('Set Break Time', 'wpamelia'),
            'set_work_time'                       => __('Set Work Time', 'wpamelia'),
            'special_day_date_warning'            => __('Please enter date', 'wpamelia'),
            'special_day_end_time_warning'        => __('Please enter end time', 'wpamelia'),
            'special_day_start_time_warning'      => __('Please enter start time', 'wpamelia'),
            'work_hours'                          => __('Work Hours', 'wpamelia'),
            'break_hours'                         => __('Break Hours', 'wpamelia'),
            'work_hours_days_off_settings'        => __('Working Hours & Days Off Settings', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the entities modal
     *
     * @return array
     */
    public static function getEntityFormStrings()
    {
        return [
            'delete'          => __('Delete', 'wpamelia'),
            'duplicate'       => __('Duplicate', 'wpamelia'),
            'loader_message'  => __('Please Wait', 'wpamelia'),
            'visibility_hide' => __('Hide', 'wpamelia'),
            'visibility_show' => __('Show', 'wpamelia'),
            'visible'         => __('Visible', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the location page
     *
     * @return array
     */
    public static function getLocationStrings()
    {
        return [
            'add_location'                   => __('Add Location', 'wpamelia'),
            'address'                        => __('Address', 'wpamelia'),
            'click_add_locations'            => __('Start by clicking the Add Location button', 'wpamelia'),
            'confirm_delete_location'        => __('Are you sure you want to delete this location?', 'wpamelia'),
            'confirm_duplicate_location'     => __('Are you sure you want to duplicate this location?', 'wpamelia'),
            'confirm_hide_location'          => __('Are you sure you want to hide this location?', 'wpamelia'),
            'confirm_show_location'          => __('Are you sure you want to show this location?', 'wpamelia'),
            'edit_location'                  => __('Edit Location', 'wpamelia'),
            'enter_location_address_warning' => __('Please enter address', 'wpamelia'),
            'enter_location_name_warning'    => __('Please enter name', 'wpamelia'),
            'latitude'                       => __('Latitude', 'wpamelia'),
            'location_address'               => __('Location Address', 'wpamelia'),
            'location_deleted'               => __('Location has been deleted', 'wpamelia'),
            'location_hidden'                => __('Your Location is hidden', 'wpamelia'),
            'location_saved'                 => __('Location has been saved', 'wpamelia'),
            'location_visible'               => __('Your Location is visible', 'wpamelia'),
            'locations_lower'                => __('locations', 'wpamelia'),
            'locations_search_placeholder'   => __('Search Locations...', 'wpamelia'),
            'longitude'                      => __('Longitude', 'wpamelia'),
            'map'                            => __('Map', 'wpamelia'),
            'new_location'                   => __('New Location', 'wpamelia'),
            'no_locations_yet'               => __('You don\'t have any locations here yet...', 'wpamelia'),
            'not_right_address'              => __('This is not the right address?', 'wpamelia'),
            'pin_icon'                       => __('Pin Icon', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the service page
     *
     * @return array
     */
    public static function getServiceStrings()
    {
        return [
            'add_category'                       => __('Add Category', 'wpamelia'),
            'add_extra'                          => __('Add Extra', 'wpamelia'),
            'add_image'                          => __('Add Image', 'wpamelia'),
            'add_package'                        => __('Add Package', 'wpamelia'),
            'add_service'                        => __('Add Service', 'wpamelia'),
            'available_images'                   => __('Available Images', 'wpamelia'),
            'bringing_anyone'                    => __('Show "Bringing anyone with you" option', 'wpamelia'),
            'bringing_anyone_tooltip'            => __('Hide this option to allow only individual people to<br/>book a group appointment without the possibility<br/>to come with somebody.', 'wpamelia'),
            'categories'                         => __('Categories', 'wpamelia'),
            'categories_delete_fail'             => __('Unable to delete category', 'wpamelia'),
            'categories_positions_saved'         => __('Categories positions has been saved', 'wpamelia'),
            'categories_positions_saved_fail'    => __('Unable to save categories positions', 'wpamelia'),
            'category'                           => __('Category', 'wpamelia'),
            'category_add_fail'                  => __('Unable to add category', 'wpamelia'),
            'category_deleted'                   => __('Category has been deleted', 'wpamelia'),
            'category_duplicated'                => __('Category has been duplicated', 'wpamelia'),
            'category_saved'                     => __('Category has been saved', 'wpamelia'),
            'category_saved_fail'                => __('Unable to save category', 'wpamelia'),
            'click_add_category'                 => __('Start by clicking the Add Category button', 'wpamelia'),
            'click_add_package'                  => __('Start by clicking the Add Package button', 'wpamelia'),
            'click_add_service'                  => __('Start by clicking the Add Service button', 'wpamelia'),
            'confirm_delete_service'             => __('Are you sure you want to delete this service?', 'wpamelia'),
            'confirm_duplicate_service'          => __('Are you sure you want to duplicate this service?', 'wpamelia'),
            'confirm_global_change_service'      => __('You will change a setting which is also set for each employee separately. Do you want to update it for all employees?', 'wpamelia'),
            'confirm_hide_service'               => __('Are you sure you want to hide this service?', 'wpamelia'),
            'confirm_show_service'               => __('Are you sure you want to show this service?', 'wpamelia'),
            'confirm_delete_package'             => __('Are you sure you want to delete this package?', 'wpamelia'),
            'confirm_duplicate_package'          => __('Are you sure you want to duplicate this package?', 'wpamelia'),
            'confirm_hide_package'               => __('Are you sure you want to hide this package?', 'wpamelia'),
            'confirm_show_package'               => __('Are you sure you want to show this package?', 'wpamelia'),
            'delete_category_confirmation'       => __('Are you sure you want to delete this category', 'wpamelia'),
            'delete_extra_confirmation'          => __('Are you sure you want to delete this extra', 'wpamelia'),
            'edit_package'                       => __('Edit Package', 'wpamelia'),
            'edit_service'                       => __('Edit Service', 'wpamelia'),
            'enter_extra_name_warning'           => __('Please enter extra name', 'wpamelia'),
            'enter_extra_price_warning'          => __('Please enter extra price', 'wpamelia'),
            'enter_non_negative_price_warning'   => __('Price must be non-negative number', 'wpamelia'),
            'enter_name_warning'                 => __('Please enter name', 'wpamelia'),
            'enter_service_price_warning'        => __('Please enter price', 'wpamelia'),
            'extra_delete_fail'                  => __('Unable to delete extra', 'wpamelia'),
            'gallery'                            => __('Gallery', 'wpamelia'),
            'hex'                                => __('Hex', 'wpamelia'),
            'maximum_capacity'                   => __('Maximum Capacity', 'wpamelia'),
            'maximum_capacity_tooltip'           => __('Here you can set the maximum number of persons<br/>per one appointment.', 'wpamelia'),
            'maximum_quantity'                   => __('Maximum Quantity', 'wpamelia'),
            'minimum_capacity'                   => __('Minimum Capacity', 'wpamelia'),
            'minimum_capacity_tooltip'           => __('Here you can set the minimum number of persons<br/>per one booking of this service.', 'wpamelia'),
            'aggregated_price'                   => __('The price will multiply by the number of people', 'wpamelia'),
            'aggregated_price_tooltip'           => __(' If you disable this option the price will be the same<br/>regardless of how many customers book in the group appointment.', 'wpamelia'),
            'new_category'                       => __('New Category', 'wpamelia'),
            'new_package'                        => __('New Package', 'wpamelia'),
            'new_service'                        => __('New Service', 'wpamelia'),
            'no_categories_yet'                  => __('You don\'t have any categories here yet...', 'wpamelia'),
            'package_appointment_left'           => __('Appointment slots left to be booked.', 'wpamelia'),
            'package_book_appointment'           => __('Book Appointment', 'wpamelia'),
            'package_date_purchased'             => __('Date Purchased', 'wpamelia'),
            'package_details'                    => __('Package Details', 'wpamelia'),
            'package_hidden'                     => __('Package is hidden', 'wpamelia'),
            'package_saved'                      => __('Package has been saved', 'wpamelia'),
            'package_visible'                    => __('Package is visible', 'wpamelia'),
            'package_deleted'                    => __('Package has been deleted', 'wpamelia'),
            'packages_sorting'                   => __('Sort Packages:', 'wpamelia'),
            'package_payment_status'             => __('Payment Status', 'wpamelia'),
            'package_price_calculated'           => __('Calculated price', 'wpamelia'),
            'package_price_calculated_text'      => __('Calculated price for package', 'wpamelia'),
            'package_price_custom'               => __('Custom price', 'wpamelia'),
            'packages_positions_saved'           => __('Packages positions has been saved', 'wpamelia'),
            'packages_positions_saved_fail'      => __('Unable to save packages positions', 'wpamelia'),
            'package_total'                      => __('Total', 'wpamelia'),
            'package_to_be_booked'               => __('to be booked', 'wpamelia'),
            'price'                              => __('Price', 'wpamelia'),
            'purchased_packages'                 => __('Purchases', 'wpamelia'),
            'schedule_package_total'             => __('Number of appointments', 'wpamelia'),
            'schedule_package_total_tooltip'     => __('A number of appointments included in the package for this service.', 'wpamelia'),
            'schedule_package_minimum'           => __('Minimum bookings required', 'wpamelia'),
            'schedule_package_minimum_tooltip'   => __('A minimum number of appointments a customer needs to schedule at the moment of booking.', 'wpamelia'),
            'schedule_package_maximum'           => __('Maximum bookings required', 'wpamelia'),
            'schedule_package_maximum_tooltip'   => __('A maximum number of appointments a customer can schedule at the moment of booking.', 'wpamelia'),
            'select_package_service_warning'     => __('Please select select at least one service', 'wpamelia'),
            'select_service_category_warning'    => __('Please select category', 'wpamelia'),
            'select_service_duration_warning'    => __('Please select duration', 'wpamelia'),
            'select_service_employee_warning'    => __('Please select select at least one employee', 'wpamelia'),
            'service_buffer_time_after'          => __('Buffer Time After', 'wpamelia'),
            'service_buffer_time_after_tooltip'  => __('Time after the appointment (rest, clean up, etc.),<br/>when another booking for same service and<br/>employee cannot be made.', 'wpamelia'),
            'service_buffer_time_before'         => __('Buffer Time Before', 'wpamelia'),
            'service_buffer_time_before_tooltip' => __('Time needed to prepare for the appointment, when<br/>another booking for same service and employee<br/>cannot be made.', 'wpamelia'),
            'service_deleted'                    => __('Service has been deleted', 'wpamelia'),
            'service_details'                    => __('Service Details', 'wpamelia'),
            'service_hidden'                     => __('Service is hidden', 'wpamelia'),
            'service_provider_remove_fail'       => __('Provider has appointments for this service', 'wpamelia'),
            'service_saved'                      => __('Service has been saved', 'wpamelia'),
            'service_visible'                    => __('Service is visible', 'wpamelia'),
            'services_positions_saved'           => __('Services positions has been saved', 'wpamelia'),
            'services_positions_saved_fail'      => __('Unable to save services positions', 'wpamelia'),
            'services_sorting'                   => __('Sort Services:', 'wpamelia'),
            'services_sorting_custom'            => __('Custom', 'wpamelia'),
            'services_sorting_name_asc'          => __('Name Ascending', 'wpamelia'),
            'services_sorting_name_desc'         => __('Name Descending', 'wpamelia'),
            'services_sorting_price_asc'         => __('Price Ascending', 'wpamelia'),
            'services_sorting_price_desc'        => __('Price Descending', 'wpamelia'),
            'service_show_on_site'               => __('Show service on site', 'wpamelia'),
            'service_show_on_site_tooltip'       => __('If this option is disabled, service will be available for booking from back-end pages only.', 'wpamelia'),
            'service_recurring_cycle'            => __('Set recurring appointment', 'wpamelia'),
            'service_recurring_cycle_tooltip'    => __('If this option is disabled, your customers won\'t be able to book recurring appointments at the same time.', 'wpamelia'),
            'service_recurring_sub'              => __('Handle unavailable recurring dates', 'wpamelia'),
            'service_recurring_sub_tooltip'      => __('Set how an alternate date should be suggested to the customer<br>if the desired date has no available time-slots for booking.', 'wpamelia'),
            'service_recurring_sub_future'       => __('Recommend the closest date after', 'wpamelia'),
            'service_recurring_sub_past'         => __('Recommend the closest date before ', 'wpamelia'),
            'service_recurring_sub_both'         => __('Recommend the closest date before or after', 'wpamelia'),
            'service_recurring_payment'          => __('Handle recurring appointment payments', 'wpamelia'),
            'service_recurring_payment_tooltip'  => __('Set how you want payments to be processed.<br>If you choose to request payment only for the first appointment customers will be able to pay the rest on-site.', 'wpamelia'),
            'service_recurring_payment_none'     => __('Customers will have to pay only for the first appointment', 'wpamelia'),
            'service_recurring_payment_all'      => __('Customers will have to pay for all appointments at once', 'wpamelia'),
            'time'                               => __('Time', 'wpamelia'),
            'update_for_all'                     => __('Update for all', 'wpamelia'),
            'mandatory_extra_enable'             => __('Set extra as a mandatory field', 'wpamelia'),
            'min_required_extras'                => __('Minimum required extras', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the user page
     *
     * @return array
     */
    public static function getUserStrings()
    {
        return [
            'create_new'               => __('Create New', 'wpamelia'),
            'email'                    => __('Email', 'wpamelia'),
            'enter_first_name_warning' => __('Please enter first name', 'wpamelia'),
            'enter_last_name_warning'  => __('Please enter last name', 'wpamelia'),
            'first_name'               => __('First Name', 'wpamelia'),
            'last_name'                => __('Last Name', 'wpamelia'),
            'female'                   => __('Female', 'wpamelia'),
            'male'                     => __('Male', 'wpamelia'),
            'select_wp_user'           => __('Select or Create New', 'wpamelia'),
            'wp_user'                  => __('WordPress User', 'wpamelia'),
            'wp_user_customer_tooltip' => __('Here you can map a WordPress user to the customer if<br/>you want to give customers access to the list of their<br/>appointments in the back-end of the plugin.', 'wpamelia'),
            'wp_user_employee_tooltip' => __('Here you can map a WordPress user to the employee if<br/>you want to give employee access to the list of their<br/>appointments in the back-end of the plugin.', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the employee page
     *
     * @return array
     */
    public static function getEmployeeStrings()
    {
        return [
            'activity'                         => __('Status', 'wpamelia'),
            'add_employee'                     => __('Add Employee', 'wpamelia'),
            'assigned_services'                => __('Assigned Services', 'wpamelia'),
            'available'                        => __('Available', 'wpamelia'),
            'away'                             => __('Away', 'wpamelia'),
            'break'                            => __('On Break', 'wpamelia'),
            'busy'                             => __('Busy', 'wpamelia'),
            'capacity'                         => __('Capacity', 'wpamelia'),
            'click_add_employee'               => __('Start by clicking the Add Employee button', 'wpamelia'),
            'confirm_delete_employee'          => __('Are you sure you want to delete this employee?', 'wpamelia'),
            'confirm_duplicate_employee'       => __('Are you sure you want to duplicate this employee?', 'wpamelia'),
            'confirm_hide_employee'            => __('Are you sure you want to hide this employee?', 'wpamelia'),
            'confirm_show_employee'            => __('Are you sure you want to show this employee?', 'wpamelia'),
            'connect'                          => __('Connect', 'wpamelia'),
            'dayoff'                           => __('Day Off', 'wpamelia'),
            'disconnect'                       => __('Disconnect', 'wpamelia'),
            'edit_employee'                    => __('Edit Employee', 'wpamelia'),
            'employee_deleted'                 => __('Employee has been deleted', 'wpamelia'),
            'employee_hidden'                  => __('Employee is hidden', 'wpamelia'),
            'employee_not_deleted'             => __('Employee can not be deleted because of the future appointment', 'wpamelia'),
            'employee_saved'                   => __('Employee has been saved', 'wpamelia'),
            'employee_search_placeholder'      => __('Search Employees...', 'wpamelia'),
            'employee_visible'                 => __('Employee is visible', 'wpamelia'),
            'employees_deleted'                => __('Employees have been deleted', 'wpamelia'),
            'employees_lower'                  => __('employees', 'wpamelia'),
            'employees_not_deleted'            => __('Employees could not be deleted because of the future appointment', 'wpamelia'),
            'employee_panel_password'          => __('Employee Panel Password', 'wpamelia'),
            'enter_location_warning'           => __('Please select location', 'wpamelia'),
            'google_sign_in'                   => __('Sign in with Google', 'wpamelia'),
            'google_sign_out'                  => __('Sign out from Google', 'wpamelia'),
            'outlook_sign_in'                  => __('Sign in with Outlook', 'wpamelia'),
            'outlook_sign_out'                 => __('Sign out from Outlook', 'wpamelia'),
            'google_calendar_error'            => __('Unable to connect to Google Calendar', 'wpamelia'),
            'google_calendar_tooltip'          => __('Here you can connect employee with Google Calendar,<br/>so once the appointment is scheduled it will be<br/>automatically added to employee\'s calendar.', 'wpamelia'),
            'outlook_calendar_tooltip'         => __('Here you can connect employee with Outlook Calendar,<br/>so once the appointment is scheduled it will be<br/>automatically added to employee\'s calendar.', 'wpamelia'),
            'grid_view'                        => __('Grid View', 'wpamelia'),
            'new_employee'                     => __('New Employee', 'wpamelia'),
            'period_location_filter'           => __('Applied for default employee location', 'wpamelia'),
            'period_location_filter1_tooltip'  => __('Select specific location for this period.', 'wpamelia'),
            'period_location_filter2_tooltip'  => __('Select specific location for each period.', 'wpamelia'),
            'period_services_filter'           => __('Applied for all assigned services', 'wpamelia'),
            'period_services_filter1_tooltip'  => __('Select only specific services for this period.<br/>If no services are selected, then all assigned services for this employee<br/>will be available for booking in this period.', 'wpamelia'),
            'period_services_filter2_tooltip'  => __('Select specific services for each period.', 'wpamelia'),
            'price'                            => __('Price', 'wpamelia'),
            'service_provider_remove_fail'     => __('Provider has appointments for this service', 'wpamelia'),
            'service_provider_remove_fail_all' => __('Provider has appointments for', 'wpamelia'),
            'special_days'                     => __('Special Days', 'wpamelia'),
            'special_days_reflect_services'    => __('Reflect On', 'wpamelia'),
            'table_view'                       => __('Table View', 'wpamelia'),
            'password'                         => __('Password', 'wpamelia'),
            'enter_employee_panel_password'    => __('Enter to set or reset password', 'wpamelia'),
            'send_employee_panel_access_email' => __('Send Employee Panel Access Email', 'wpamelia'),
            'new_password_length'              => __('Password must be longer than 3 characters', 'wpamelia'),
            'zoom_user_tooltip'                => __('Here you can select Zoom User,<br/>so once the appointment is scheduled,<br/>zoom meeting will be automatically created.', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the customer page
     *
     * @return array
     */
    public static function getCustomerStrings()
    {
        return [
            'add_customer'                 => __('Add Customer', 'wpamelia'),
            'click_add_customers'          => __('Start by clicking the Add Customer button', 'wpamelia'),
            'confirm_delete_customer'      => __('Are you sure you want to delete this customer?', 'wpamelia'),
            'customer_deleted'             => __('Customer has been deleted', 'wpamelia'),
            'customer_not_deleted'         => __('Customer can not be deleted because of the future appointment', 'wpamelia'),
            'customer_note'                => __('Note', 'wpamelia'),
            'customer_saved'               => __('Customer has been saved', 'wpamelia'),
            'customers'                    => __('Customers', 'wpamelia'),
            'customers_deleted'            => __('Customers have been deleted', 'wpamelia'),
            'customers_lower'              => __('customers', 'wpamelia'),
            'customers_not_deleted'        => __('Customers could not be deleted because of the future appointment', 'wpamelia'),
            'customers_search_placeholder' => __('Search Customers...', 'wpamelia'),
            'date_of_birth'                => __('Date of Birth', 'wpamelia'),
            'edit_customer'                => __('Edit Customer', 'wpamelia'),
            'email_placeholder'            => __('example@mail.com', 'wpamelia'),
            'export_tooltip_customers'     => __('You can use this option to export customers in CSV file.', 'wpamelia'),
            'gender'                       => __('Gender', 'wpamelia'),
            'last_appointment'             => __('Last Appointment', 'wpamelia'),
            'last_appointment_ascending'   => __('Last Appointment Ascending', 'wpamelia'),
            'last_appointment_descending'  => __('Last Appointment Descending', 'wpamelia'),
            'new_customer'                 => __('New Customer', 'wpamelia'),
            'no_customers_yet'             => __('You don\'t have any customers here yet...', 'wpamelia'),
            'note_internal'                => __('Note (Internal)', 'wpamelia'),
            'pending_appointments'         => __('Pending Appointments', 'wpamelia'),
            'select_date_of_birth'         => __('Select Date of Birth', 'wpamelia'),
            'total_appointments'           => __('Total Appointments', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the finance page
     *
     * @return array
     */
    public static function getFinanceStrings()
    {
        return [
            'amount'                             => __('Amount', 'wpamelia'),
            'booking_start'                      => __('Booking Start', 'wpamelia'),
            'code'                               => __('Code', 'wpamelia'),
            'code_tooltip'                       => __('Here you need to define a coupon code which customers will<br/>enter in their booking so they can get a discount.', 'wpamelia'),
            'confirm_delete_coupon'              => __('Are you sure you want to delete this coupon?', 'wpamelia'),
            'confirm_duplicate_coupon'           => __('Are you sure you want to duplicate this coupon?', 'wpamelia'),
            'confirm_hide_coupon'                => __('Are you sure you want to hide this coupon?', 'wpamelia'),
            'confirm_show_coupon'                => __('Are you sure you want to show this coupon?', 'wpamelia'),
            'coupon_deleted'                     => __('Coupon has been deleted', 'wpamelia'),
            'coupon_hidden'                      => __('Your Coupon is hidden', 'wpamelia'),
            'coupon_not_deleted'                 => __('Coupon has not been deleted', 'wpamelia'),
            'coupon_saved'                       => __('Coupon has been saved', 'wpamelia'),
            'coupon_usage_limit_validation'      => __('Coupon usage limit must be at least 1', 'wpamelia'),
            'coupon_visible'                     => __('Your Coupon is active', 'wpamelia'),
            'coupons'                            => __('Coupons', 'wpamelia'),
            'coupons_deleted'                    => __('Coupons have been deleted', 'wpamelia'),
            'coupons_lower'                      => __('coupons', 'wpamelia'),
            'coupons_multiple_services_text'     => __(' & Other Services', 'wpamelia'),
            'coupons_multiple_events_text'       => __(' & Other Events', 'wpamelia'),
            'coupons_not_deleted'                => __('Coupons have not been deleted', 'wpamelia'),
            'customer_email'                     => __('Customer Email', 'wpamelia'),
            'deduction'                          => __('Deduction', 'wpamelia'),
            'edit_coupon'                        => __('Edit Coupon', 'wpamelia'),
            'employee_email'                     => __('Employee Email', 'wpamelia'),
            'enter_coupon_code_warning'          => __('Please enter code', 'wpamelia'),
            'export_tooltip_coupons'             => __('You can use this option to export coupons in CSV file.', 'wpamelia'),
            'export_tooltip_payments'            => __('You can use this option to export payments in CSV file<br/>for the selected date range.', 'wpamelia'),
            'finance_coupons_search_placeholder' => __('Search Coupons', 'wpamelia'),
            'limit'                              => __('Limit', 'wpamelia'),
            'method'                             => __('Method', 'wpamelia'),
            'new_coupon'                         => __('New Coupon', 'wpamelia'),
            'no_coupon_amount'                   => __('Coupon needs to have discount or deduction', 'wpamelia'),
            'no_coupons_yet'                     => __('You don\'t have any coupons here yet', 'wpamelia'),
            'no_payments_yet'                    => __('You don\'t have any payments here yet', 'wpamelia'),
            'no_entities_selected'               => __('Select at least one service or event', 'wpamelia'),
            'paid'                               => __('Paid', 'wpamelia'),
            'payment_date'                       => __('Payment date', 'wpamelia'),
            'payments'                           => __('Payments', 'wpamelia'),
            'payments_lower'                     => __('payments', 'wpamelia'),
            'pending'                            => __('Pending', 'wpamelia'),
            'send_interval'                      => __('Notification interval', 'wpamelia'),
            'send_interval_tooltip'              => __('Here you can set the number of approved bookings after which the customer will automatically receive the coupon in notification.<br/>Please note that the coupon placeholder needs to be set in the notification template in order for this to work.', 'wpamelia'),
            'send_recurring'                     => __('Recurring notification', 'wpamelia'),
            'send_recurring_tooltip'             => __('Here you can define if notification interval will repeat.', 'wpamelia'),
            'select_all_services'                => __('Select All Service', 'wpamelia'),
            'services_tooltip'                   => __('Select the services for which the coupon can be used.', 'wpamelia'),
            'select_all_events'                  => __('Select All Events', 'wpamelia'),
            'events_tooltip'                     => __('Select the events for which the coupon can be used.', 'wpamelia'),
            'times_used'                         => __('Times Used', 'wpamelia'),
            'usage_limit'                        => __('Usage Limit', 'wpamelia'),
            'usage_limit_tooltip'                => __('Here you need to define the number of coupons for use. After the<br/>limit is reached your coupon will become unavailable.', 'wpamelia'),
            'usage_customer_limit'               => __('Maximum Usage Per Customer', 'wpamelia'),
            'usage_customer_limit_tooltip'       => __('Here you can define the maximum number of coupons for use for single customer. After the<br/>limit is reached for single customer, your coupon will become unavailable for that customer.', 'wpamelia'),
            'used'                               => __('Used', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the finance page
     *
     * @return array
     */
    public static function getPaymentStrings()
    {
        return [
            'appointment_date'         => __('Appointment Date', 'wpamelia'),
            'appointment_info'         => __('Appointment Info', 'wpamelia'),
            'event_info'               => __('Event Info', 'wpamelia'),
            'event_date'               => __('Event Date', 'wpamelia'),
            'confirm_delete_payment'   => __('Are you sure you want to delete this payment?', 'wpamelia'),
            'discount_amount'          => __('Discount', 'wpamelia'),
            'deduction'                => __('Deduction', 'wpamelia'),
            'due'                      => __('Due', 'wpamelia'),
            'enter_new_payment_amount' => __('Enter new payment amount', 'wpamelia'),
            'finance'                  => __('Finance', 'wpamelia'),
            'package_deal'             => __('This booking is part of a package deal', 'wpamelia'),
            'paid'                     => __('Paid', 'wpamelia'),
            'payment_deleted'          => __('Payment has been deleted', 'wpamelia'),
            'payment_details'          => __('Payment Details', 'wpamelia'),
            'payment_not_deleted'      => __('Payment has not been deleted', 'wpamelia'),
            'payment_saved'            => __('Payment has been saved', 'wpamelia'),
            'payments_deleted'         => __('Payments have been deleted', 'wpamelia'),
            'payments_not_deleted'     => __('Payments have not been deleted', 'wpamelia'),
            'service_price'            => __('Service Price', 'wpamelia'),
            'event_price'              => __('Event Price', 'wpamelia'),
            'subtotal'                 => __('Subtotal', 'wpamelia')
        ];
    }

    /**
     * Returns the array for the appointment strings
     *
     * @return array
     */
    public static function getAppointmentStrings()
    {
        return [
            'appointment_deleted'               => __('Appointment has been deleted', 'wpamelia'),
            'appointment_id'                    => __('Appointment ID', 'wpamelia'),
            'appointment_not_deleted'           => __('Appointment has not been deleted', 'wpamelia'),
            'appointment_saved'                 => __('Appointment has been saved', 'wpamelia'),
            'appointment_status_changed'        => __('Appointment status has been changed to ', 'wpamelia'),
            'appointments_deleted'              => __('Appointments have been deleted', 'wpamelia'),
            'appointments_not_deleted'          => __('Appointment have not been deleted', 'wpamelia'),
            'appointments_search_placeholder'   => __('Search for Customers, Employees, Services...', 'wpamelia'),
            'assigned'                          => __('Assigned', 'wpamelia'),
            'assigned_to'                       => __('Assigned to', 'wpamelia'),
            'cancel_appointment'                => __('Cancel Appointment', 'wpamelia'),
            'category'                          => __('Category', 'wpamelia'),
            'change_group_status'               => __('Change group status', 'wpamelia'),
            'choose_a_group_service'            => __('Choose a group service', 'wpamelia'),
            'click_add_appointments'            => __('Start by clicking the New Appointment button', 'wpamelia'),
            'confirm_delete_appointment'        => __('Are you sure you want to delete this appointment?', 'wpamelia'),
            'confirm_delete_appointment_plural' => __('Are you sure you want to delete these appointments?', 'wpamelia'),
            'confirm_delete_package_purchase'   => __('Are you sure you want to delete this package purchase and it\'s appointments?', 'wpamelia'),
            'confirm_duplicate_appointment'     => __('Are you sure you want to duplicate this appointment?', 'wpamelia'),
            'create_customer'                   => __('Create Customer', 'wpamelia'),
            'create_new'                        => __('Create New', 'wpamelia'),
            'custom_fields'                     => __('Custom Fields', 'wpamelia'),
            'customer_email'                    => __('Customer Email', 'wpamelia'),
            'customer_name'                     => __('Customer Name', 'wpamelia'),
            'customer_phone'                    => __('Customer Phone', 'wpamelia'),
            'customers'                         => __('Customers', 'wpamelia'),
            'customers_singular_plural'         => __('Customer(s)', 'wpamelia'),
            'customers_tooltip'                 => __('Here you can define the number of people that are coming<br/>with this customer. The number you can choose depends<br/>on the service and employee capacity.', 'wpamelia'),
            'edit_appointment'                  => __('Edit Appointment', 'wpamelia'),
            'end_time'                          => __('End Time', 'wpamelia'),
            'export_tooltip_appointments'       => __('You can use this option to export appointments in CSV file<br/>for the selected date range.', 'wpamelia'),
            'export_tooltip_attendees'          => __('You can use this option to export attendees in CSV file<br/>for the selected event.', 'wpamelia'),
            'minimum_number_of_persons'         => __('Minimum number of persons for bookings to approve appointment is', 'wpamelia'),
            'multiple_emails'                   => __('Multiple Emails', 'wpamelia'),
            'new_appointment'                   => __('New Appointment', 'wpamelia'),
            'no_appointments_yet'               => __('You don\'t have any appointments here yet...', 'wpamelia'),
            'no_selected_customers'             => __('There are no selected customers', 'wpamelia'),
            'no_selected_extras_requirements'   => __('Select customer, employee and service', 'wpamelia'),
            'no_selected_slot_requirements'     => __('Select date and time', 'wpamelia'),
            'no_selected_fields_requirements'   => __('Select customer and service', 'wpamelia'),
            'notify_customers'                  => __('Notify the customer(s)', 'wpamelia'),
            'notify_customers_tooltip'          => __('Check this checkbox if you want your customer to<br/>receive an email about the scheduled appointment.', 'wpamelia'),
            'bookings_regular_tooltip'          => __('customers booked this appointment out of package deal', 'wpamelia'),
            'bookings_package_tooltip'          => __('customers booked this appointment as a part of package:', 'wpamelia'),
            'bookings_payment_package_tooltip'  => __('Payments for the package deal are not included in this paid amount', 'wpamelia'),
            'recurring_changed_message'         => __('List of your appointments has changed. Take one more look and continue by clicking the Save button.', 'wpamelia'),
            'required_field'                    => __('This field is required', 'wpamelia'),
            'package_customer_deleted'          => __('Package purchase has been deleted', 'wpamelia'),
            'package_customer_not_deleted'      => __('Package purchase has not been deleted', 'wpamelia'),
            'package_customers_deleted'         => __('Package purchases have been deleted', 'wpamelia'),
            'package_customers_not_deleted'     => __('Package purchases have not been deleted', 'wpamelia'),
            'package_deal'                      => __('Package deal', 'wpamelia'),
            'price'                             => __('Price', 'wpamelia'),
            'schedule'                          => __('Schedule', 'wpamelia'),
            'select_customer_warning'           => __('Please select at least one customer', 'wpamelia'),
            'select_customers'                  => __('Select Customer(s)', 'wpamelia'),
            'select_employee'                   => __('Select Employee', 'wpamelia'),
            'select_employee_warning'           => __('Please select employee', 'wpamelia'),
            'select_coupon'                     => __('Select Coupon', 'wpamelia'),
            'select_location'                   => __('Select Location', 'wpamelia'),
            'select_max_customer_count_warning' => __('Maximum number of places is', 'wpamelia'),
            'select_service'                    => __('Select Service', 'wpamelia'),
            'select_service_category'           => __('Select Service Category', 'wpamelia'),
            'select_service_warning'            => __('Please select service', 'wpamelia'),
            'select_rows_settings'              => __('Choose how to export group appointments', 'wpamelia'),
            'selected_customers'                => __('Selected Customers', 'wpamelia'),
            'service_category'                  => __('Service Category', 'wpamelia'),
            'service_no_extras'                 => __('This service does not have any extras', 'wpamelia'),
            'exported_same_row'                 => __('Booking info from group appointment exported in the same row', 'wpamelia'),
            'exported_separate_rows'            => __('Booking info from group appointment exported in separate rows', 'wpamelia'),
            'start_time'                        => __('Start Time', 'wpamelia'),
            'time'                              => __('Time', 'wpamelia'),
            'time_slot_unavailable'             => __('Time slot is unavailable', 'wpamelia'),
            'package_booking_unavailable'       => __('Booking is unavailable', 'wpamelia'),
            'view_payment_details'              => __('View Payment Details', 'wpamelia'),
            'booking_cancel_exception'          => __('Appointment can\'t be canceled', 'wpamelia'),
            'booking_reschedule_exception'      => __('Appointment can\'t be rescheduled', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the bookable strings
     *
     * @return array
     */
    public static function getBookableStrings() {
        return [
            'allow_customers_to_pay_total'       => __('Check this option if you want your<br> customers to have the option to choose<br> whether they will pay a full amount<br> or just a deposit. If unchecked,<br> customers will only have deposit<br> as a payment option.', 'wpamelia'),
            'deposit_by_the_number_of_people'    => __('Check this option if you want the deposit<br> amount to be multiplied by the number<br> of people that customers add in the<br> "Bringing anyone with you" section.', 'wpamelia'),
            'deposit_amount'                     => __('Deposit amount', 'wpamelia'),
            'deposit_enabled'                    => __('Enable deposit payment', 'wpamelia'),
            'deposit_payment'                    => __('Deposit type', 'wpamelia'),
            'deposit_payment_tooltip'            => __('Percentage deposit will be calculated on the total booking price<br>and fixed amount can be multiplied by the number of persons or stay fixed on the total booking price.', 'wpamelia'),
            'deposit_info'                       => __('Remaining of total amount will be paid on site.', 'wpamelia'),
            'deposit_info_fixed'                 => __('Remaining of total amount will be paid on site. Extras are not included in deposit amount.', 'wpamelia'),
            'deposit_info_percentage'            => __('Remaining of total amount will be paid on site. Extras are included in deposit amount.', 'wpamelia'),
            'deposit_per_person'                 => __('Multiply deposit amount by the number of people in one booking', 'wpamelia'),
            'deposit_per_person_tooltip'         => __('Multiply deposit amount by the number of people in one booking', 'wpamelia'),
            'allow_total_amount'                 => __('Allow customers to pay total appointment amount', 'wpamelia'),
            'fixed_amount'                       => __('Fixed amount', 'wpamelia'),
            'percentage'                         => __('Percentage', 'wpamelia'),
            'enter_positive_price_warning'       => __('Amount must be positive number', 'wpamelia'),
        ];
    }


    /**
     * Returns the array for the event strings
     *
     * @return array
     */
    public static function getEventStrings()
    {
        return [
            'apply_to_all'                => __('Apply this to all recurring events', 'wpamelia'),
            'click_add_events'            => __('Start by clicking the New Event button', 'wpamelia'),
            'confirm_delete_attendee'     => __('Are you sure you want to delete selected attendee?', 'wpamelia'),
            'confirm_delete_attendees'    => __('Are you sure you want to delete selected attendees?', 'wpamelia'),
            'confirm_delete'              => __('Are you sure you want to delete this event?', 'wpamelia'),
            'confirm_delete_following'    => __('Do you want to delete following canceled events?', 'wpamelia'),
            'confirm_duplicate_event'     => __('Are you sure you want to duplicate this event?', 'wpamelia'),
            'confirm_cancel'              => __('Are you sure you want to cancel this event?', 'wpamelia'),
            'confirm_cancel_following'    => __('Do you want to cancel following events?', 'wpamelia'),
            'confirm_open'                => __('Are you sure you want to open this event?', 'wpamelia'),
            'confirm_open_following'      => __('Do you want to open following events?', 'wpamelia'),
            'confirm_save_following'      => __('Do you want to update following events?', 'wpamelia'),
            'description'                 => __('Description', 'wpamelia'),
            'event_cancel_before_delete'  => __('Please cancel the event first before deleting it.', 'wpamelia'),
            'customize'                   => __('Customize', 'wpamelia'),
            'closed'                      => __('Closed', 'wpamelia'),
            'full'                        => __('Full', 'wpamelia'),
            'upcoming'                    => __('Upcoming', 'wpamelia'),
            'edit_event'                  => __('Edit Event', 'wpamelia'),
            'event'                       => __('Event', 'wpamelia'),
            'event_attendees'             => __('Attendees', 'wpamelia'),
            'event_add_attendee'          => __('Add Attendee', 'wpamelia'),
            'event_book_persons'          => __('Number of persons', 'wpamelia'),
            'event_edit_attendee'         => __('Edit Attendee', 'wpamelia'),
            'event_attendee_saved'        => __('Attendee has been saved', 'wpamelia'),
            'event_attendee_remove'       => __('Remove Attendee', 'wpamelia'),
            'event_attendees_remove'      => __('Remove Selected', 'wpamelia'),
            'event_attendees_search'      => __('Find Attendees', 'wpamelia'),
            'event_attendee_deleted'      => __('Attendee have been deleted', 'wpamelia'),
            'event_attendee_not_deleted'  => __('Attendee have not been deleted', 'wpamelia'),
            'event_attendees_deleted'     => __('Attendees have been deleted', 'wpamelia'),
            'event_attendees_not_deleted' => __('Attendees have not been deleted', 'wpamelia'),
            'event_book_more_than_once'   => __('Allow the same customer to book more than once', 'wpamelia'),
            'event_bringing_anyone'       => __('Allow bringing more persons', 'wpamelia'),
            'event_cancel'                => __('Cancel Event', 'wpamelia'),
            'event_capacity'              => __('Spots:', 'wpamelia'),
            'event_custom_address'        => __('Custom Address', 'wpamelia'),
            'event_delete'                => __('Delete Event', 'wpamelia'),
            'event_deleted'               => __('Event has been deleted', 'wpamelia'),
            'event_duplicate'             => __('Duplicate Event', 'wpamelia'),
            'event_name'                  => __('Name:', 'wpamelia'),
            'event_location'              => __('Location:', 'wpamelia'),
            'event_booking_closes'        => __('Booking closes:', 'wpamelia'),
            'event_booking_opens'         => __('Booking opens:', 'wpamelia'),
            'event_booking_closes_on'     => __('Closes on:', 'wpamelia'),
            'event_booking_closes_apply'  => __('If this option is not checked the plugin will calculate the time <br> for closing the booking based on the selected time for the first event', 'wpamelia'),
            'event_booking_opens_on'      => __('Opens on:', 'wpamelia'),
            'event_booking_opens_apply'   => __('If this option is not checked the plugin will calculate the time <br> for opening the booking based on the selected time for the first event', 'wpamelia'),
            'event_booking_closes_after'  => __('Booking closes when event starts', 'wpamelia'),
            'event_booking_opens_now'     => __('Booking opens immediately', 'wpamelia'),
            'event_details'               => __('Event Details', 'wpamelia'),
            'event_period_time'           => __('Time:', 'wpamelia'),
            'event_open'                  => __('Open Event', 'wpamelia'),
            'event_recurring'             => __('Recurring:', 'wpamelia'),
            'event_recurring_enabled'     => __('This is a recurring event', 'wpamelia'),
            'event_recurring_period'      => __('Repeat Event', 'wpamelia'),
            'event_recurring_count'       => __('How many times?', 'wpamelia'),
            'event_recurring_until'       => __('Until when?', 'wpamelia'),
            'event_booking_deleted'       => __('Event booking has been deleted', 'wpamelia'),
            'event_booking_not_deleted'   => __('Event booking has not been deleted', 'wpamelia'),
            'event_opened'                => __('Event has been opened', 'wpamelia'),
            'event_canceled'              => __('Event has been canceled', 'wpamelia'),
            'event_saved'                 => __('Event has been saved', 'wpamelia'),
            'event_schedule'              => __('Schedule', 'wpamelia'),
            'event_search_placeholder'    => __('Search Events...', 'wpamelia'),
            'event_max_capacity'          => __('Maximum allowed spots', 'wpamelia'),
            'event_select_address'        => __('Select Address', 'wpamelia'),
            'event_staff'                 => __('Staff', 'wpamelia'),
            'event_period_dates'          => __('Dates:', 'wpamelia'),
            'event_tags'                  => __('Tags', 'wpamelia'),
            'event_tags_create'           => __('No Tags. Create a new one.', 'wpamelia'),
            'event_tags_select_or_create' => __('Select or Create Tag', 'wpamelia'),
            'enter_event_name'            => __('Enter Event Name', 'wpamelia'),
            'enter_event_name_warning'    => __('Please enter name', 'wpamelia'),
            'event_gallery'               => __('Event Gallery:', 'wpamelia'),
            'event_colors'                => __('Event Colors:', 'wpamelia'),
            'event_colors_preset'         => __('Preset Colors', 'wpamelia'),
            'event_colors_custom'         => __('Custom Color', 'wpamelia'),
            'select_repeat_period'        => __('Select Repeat Period', 'wpamelia'),
            'select_repeat_interval'      => __('Select Repeat Interval', 'wpamelia'),
            'event_show_on_site'          => __('Show event on site', 'wpamelia'),
            'event_status_changed'        => __('Booking status has been changed to ', 'wpamelia'),
            'no_events_yet'               => __('You don\'t have any events here yet...', 'wpamelia'),
            'no_attendees_yet'            => __('There are no attendees yet...', 'wpamelia'),
            'new_event'                   => __('New Event', 'wpamelia'),
            'price'                       => __('Price', 'wpamelia'),
            'enter_address'               => __('Enter Address', 'wpamelia'),
            'select'                      => __('Select', 'wpamelia'),
            'time'                        => __('Time', 'wpamelia'),
            'save_single'                 => __('No, just this one', 'wpamelia'),
            'update_following'            => __('Update following', 'wpamelia'),
            'delete_following'            => __('Delete following', 'wpamelia'),
            'cancel_following'            => __('Cancel following', 'wpamelia'),
            'open_following'              => __('Open following', 'wpamelia'),
            'cancel'                      => __('Cancel', 'wpamelia'),
            'maximum_capacity_reached'    => __('Maximum capacity is reached', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the calendar strings
     *
     * @return array
     */
    public static function getCalendarStrings()
    {
        return [
            'add_customer'                   => __('Add Customer', 'wpamelia'),
            'add_employee'                   => __('Add Employee', 'wpamelia'),
            'add_location'                   => __('Add Location', 'wpamelia'),
            'add_service'                    => __('Add Service', 'wpamelia'),
            'all_employees'                  => __('All employees', 'wpamelia'),
            'appointment_change_time'        => __('This will change the time of the appointment. Continue?', 'wpamelia'),
            'appointment_drag_breaks'        => __('Appointment can\'t be moved because of employee break in the selected period', 'wpamelia'),
            'appointment_drag_exist'         => __('There is already an appointment for this employee in selected time period', 'wpamelia'),
            'appointment_drag_out_schedule'  => __('Appointment can\'t be moved because the employee doesn\'t provide this service at the selected time', 'wpamelia'),
            'appointment_drag_past'          => __('Appointment can\'t be moved in past time period', 'wpamelia'),
            'appointment_drag_working_hours' => __('Appointment can\'t be moved out of employee working hours', 'wpamelia'),
            'appointment_rescheduled'        => __('Appointment has been rescheduled', 'wpamelia'),
            'calendar'                       => __('Calendar', 'wpamelia'),
            'confirm'                        => __('Confirm', 'wpamelia'),
            'day'                            => __('Day', 'wpamelia'),
            'group_booking'                  => __('Group appointment', 'wpamelia'),
            'list'                           => __('List', 'wpamelia'),
            'month'                          => __('Month', 'wpamelia'),
            'new_coupon'                     => __('New Coupon', 'wpamelia'),
            'no_appointments_to_display'     => __('No appointments to display', 'wpamelia'),
            'timeline'                       => __('Timeline', 'wpamelia'),
            'today'                          => __('Today', 'wpamelia'),
            'total'                          => __('Total', 'wpamelia'),
            'week'                           => __('Week', 'wpamelia'),
        ];
    }

    /**
     * Returns the array for the Customize page
     *
     * @return array
     */
    public static function getCustomizeStrings()
    {
        return [
            'add_custom_field'                   => __('Add Custom Field', 'wpamelia'),
            'add_extra'                          => __('Add Extra', 'wpamelia'),
            'add_option'                         => __('Add Option', 'wpamelia'),
            'all_services'                       => __('All services', 'wpamelia'),
            'all_events'                         => __('All events', 'wpamelia'),
            'any_employee'                       => __('Any Employee', 'wpamelia'),
            'any_location'                       => __('Any Location', 'wpamelia'),
            'package_available'                  => __('Available in package', 'wpamelia'),
            'bringing_anyone_with_you'           => __('Bringing Anyone with You?', 'wpamelia'),
            'number_of_additional_persons'       => __('Number of Additional Persons', 'wpamelia'),
            'one_person'                         => __('Person', 'wpamelia'),
            'one_persons'                        => __('Persons', 'wpamelia'),
            'package_discount_text'              => __('Save', 'wpamelia'),
            'extra_colon'                        => __('Extra', 'wpamelia'),
            'select_extra'                       => __('John Doe', 'wpamelia'),
            'select_extra2'                      => __('Jane Doe', 'wpamelia'),
            'qty_colon'                          => __('Qty', 'wpamelia'),
            'duration_colon'                     => __('Duration', 'wpamelia'),
            'price_colon'                        => __('Price', 'wpamelia'),
            'checkbox'                           => __('Checkbox', 'wpamelia'),
            'click_add_custom_field'             => __('Start by clicking the Add Custom Field button', 'wpamelia'),
            'colors_and_fonts'                   => __('Colors & Fonts', 'wpamelia'),
            'content'                            => __('Text Content', 'wpamelia'),
            'continue'                           => __('Continue', 'wpamelia'),
            'custom_field'                       => __('Custom Field', 'wpamelia'),
            'custom_fields'                      => __('Custom Fields', 'wpamelia'),
            'custom_fields_added'                => __('Custom field has been added', 'wpamelia'),
            'custom_fields_deleted'              => __('Custom field has been deleted', 'wpamelia'),
            'custom_fields_positions_saved_fail' => __('Unable to save custom fields positions', 'wpamelia'),
            'custom_field_saved'                 => __('Custom field has been saved', 'wpamelia'),
            'customize'                          => __('Customize', 'wpamelia'),
            'font'                               => __('Font', 'wpamelia'),
            'label'                              => __('Label', 'wpamelia'),
            'label_name'                         => __('Label name', 'wpamelia'),
            'no_custom_fields_yet'               => __('You don\'t have any custom fields here yet...', 'wpamelia'),
            'notification_placeholder'           => __('Notification Placeholder', 'wpamelia'),
            'options'                            => __('Options', 'wpamelia'),
            'pick_date_and_time'                 => __('Pick date & time', 'wpamelia'),
            'please_select_service'              => __('Please select service', 'wpamelia'),
            'service'                            => __('Service', 'wpamelia'),
            'primary_color'                      => __('Primary Color', 'wpamelia'),
            'primary_gradient'                   => __('Primary Gradient', 'wpamelia'),
            'radio'                              => __('Radio Buttons', 'wpamelia'),
            'required'                           => __('Required', 'wpamelia'),
            'reset'                              => __('Reset', 'wpamelia'),
            'select'                             => __('Selectbox', 'wpamelia'),
            'select_service'                     => __('Select Service', 'wpamelia'),
            'send_custom_fields_separately'      => __('Send custom fields info for each customer separately', 'wpamelia'),
            'send_custom_fields_tooltip'         => __('Enable this option if you want your employee to receive data from the custom fields only for the last customer when there is a group booking', 'wpamelia'),
            'global_customize_settings_notice'   => __('Global Settings apply only to the Event Calendar and Search Booking forms, to customize other booking forms use the settings on the right.', 'wpamelia'),
            'text'                               => __('Text', 'wpamelia'),
            'text-area'                          => __('Text Area', 'wpamelia'),
            'text_color'                         => __('Text Color', 'wpamelia'),
            'text_color_on_background'           => __('Text Color on Background', 'wpamelia'),
            'file'                               => __('Attachment', 'wpamelia'),
            'datepicker'                         => __('Date Picker', 'wpamelia'),
            'preview'                            => __('Preview', 'wpamelia'),
            'window_vue'                         => __('Use already loaded Vue', 'wpamelia'),
            'bgr_color'                          => __('Background Color', 'wpamelia'),
            'bgr_gradient_color1'                => __('Background Gradient Color 1', 'wpamelia'),
            'bgr_gradient_color2'                => __('Background Gradient Color 2', 'wpamelia'),
            'bgr_gradient_angle'                 => __('Background Gradient Angle', 'wpamelia'),
            'input_color'                        => __('Input Color', 'wpamelia'),
            'input_text_color'                   => __('Input Text Color', 'wpamelia'),
            'dropdown_color'                     => __('Dropdown Color', 'wpamelia'),
            'dropdown_text_color'                => __('Dropdown Text Color', 'wpamelia'),
            'image_color'                        => __('Image Color', 'wpamelia'),
            'recurring_active'                   => __('Repeat this appointment', 'wpamelia'),
            'service_option'                     => __('Service', 'wpamelia'),
            'employee_option'                    => __('Employee', 'wpamelia'),
            'location_option'                    => __('Location', 'wpamelia'),
            'package_option'                     => __('Package', 'wpamelia'),
            'recurring_repeat'                   => __('Repeat:', 'wpamelia'),
            'repeat_daily'                       => __('Daily', 'wpamelia'),
            'repeat_weekly'                      => __('Weekly', 'wpamelia'),
            'repeat_monthly'                     => __('Monthly', 'wpamelia'),
            'recurring_day'                      => __('Day', 'wpamelia'),
            'recurring_days'                     => __('Days', 'wpamelia'),
            'recurring_week'                     => __('Week', 'wpamelia'),
            'recurring_weeks'                    => __('Weeks', 'wpamelia'),
            'recurring_month'                    => __('Month', 'wpamelia'),
            'recurring_months'                   => __('Months', 'wpamelia'),
            'recurring_every'                    => __('Every:', 'wpamelia'),
            'recurring_on'                       => __('On:', 'wpamelia'),
            'recurring_until'                    => __('Until:', 'wpamelia'),
            'recurring_times'                    => __('Time(s):', 'wpamelia'),
            'recurring_appointments'             => __('Recurring Appointments', 'wpamelia'),
            'recurring_edit'                     => __('You can edit or delete each appointment', 'wpamelia'),
            'date'                               => __('Date', 'wpamelia'),
            'time'                               => __('Time', 'wpamelia'),
            'employee'                           => __('Employee', 'wpamelia'),
            'date_colon'                         => __('Date:', 'wpamelia'),
            'time_colon'                         => __('Local Time:', 'wpamelia'),
            'location_colon'                     => __('Location:', 'wpamelia'),
            'location_name'                      => __('Location 1', 'wpamelia'),
            'every_day_until'                    => __('Every Day until', 'wpamelia'),
            'first_name_colon'                   => __('First Name', 'wpamelia'),
            'last_name_colon'                    => __('Last Name', 'wpamelia'),
            'email_colon'                        => __('Email', 'wpamelia'),
            'phone_colon'                        => __('Phone', 'wpamelia'),
            'confirm'                            => __('Confirm', 'wpamelia'),
            'recurring_string'                   => __('Every Day until', 'wpamelia'),
            'payment_method_colon'               => __('Payment Method:', 'wpamelia'),
            'payment_type_colon'                 => __('Payment Type:', 'wpamelia'),
            'payment_on_site'                    => __('On-site', 'wpamelia'),
            'payment_paypal'                     => __('PayPal', 'wpamelia'),
            'payment_credit_card'                => __('Credit Card', 'wpamelia'),
            'credit_or_debit_card_colon'         => __('Credit or debit card:', 'wpamelia'),
            'payment_card_number'                => __('Card number', 'wpamelia'),
            'total_number_of_persons'            => __('Total Number of Persons:', 'wpamelia'),
            'base_price_colon'                   => __('Base Price:', 'wpamelia'),
            'discount_amount_colon'              => __('Discount:', 'wpamelia'),
            'total_cost_colon'                   => __('Total Cost:', 'wpamelia'),
            'please_select_package'              => __('Please select package:', 'wpamelia'),
            'package_colon'                      => __('Package:', 'wpamelia'),
            'back'                               => __('Back', 'wpamelia'),
            'package_book_service'               => __('All services are booked separately.', 'wpamelia'),
            'service_name'                       => __('Service name', 'wpamelia'),
            'package_next_appointment'           => __('Add appointment', 'wpamelia'),
            'package_min_book'                   => __('appointment is required to be booked now.', 'wpamelia'),
            'package_min_book_plural'            => __('appointments are required to be booked now.', 'wpamelia'),
            'no_selected_slot_requirements'      => __('Select date and time', 'wpamelia'),
            'package_list_overview'              => __('Overview', 'wpamelia'),
            'display_field'                      => __('Display Field:', 'wpamelia'),
            'mandatory_field'                    => __('Mandatory Field:', 'wpamelia'),
            'end_time_visibility'                => __('End Time Visibility:', 'wpamelia'),
            'any_employee_visibility'            => __('Any Employee Option Visibility:', 'wpamelia'),
            'event_type'                         => __('Event Type', 'wpamelia'),
            'event_location'                     => __('Event Location', 'wpamelia'),
            'open'                               => __('Open', 'wpamelia'),
            'full'                               => __('Full', 'wpamelia'),
            'upcoming'                           => __('Upcoming', 'wpamelia'),
            'event_free'                         => __('Free', 'wpamelia'),
            'event_capacity'                     => __('Capacity', 'wpamelia'),
            'event_date'                         => __('Event Date and Time', 'wpamelia'),
            'event_price'                        => __('Event Price', 'wpamelia'),
            'event_about'                        => __('About this Event', 'wpamelia'),
            'event_book'                         => __('Book this event', 'wpamelia'),
            'event_book_persons'                 => __('Number of persons', 'wpamelia'),
            'categories'                         => __('Categories', 'wpamelia'),
            'services_lower'                     => __('services', 'wpamelia'),
            'service_images_thumbs'              => __('Image Thumbs', 'wpamelia'),
            'view_more'                          => __('View More', 'wpamelia'),
            'service_badge'                      => __('Service badge', 'wpamelia'),
            'service_price'                      => __('Service price', 'wpamelia'),
            'service_employees_list'             => __('Service employees list', 'wpamelia'),
            'package_badge'                      => __('Package badge', 'wpamelia'),
            'package_price'                      => __('Package price', 'wpamelia'),
            'package_services_list'              => __('Package services list', 'wpamelia'),
            'h'                                  => __('h', 'wpamelia'),
            'min'                                => __('min', 'wpamelia'),
            'service_info'                       => __('Service Info', 'wpamelia'),
            'maximum_quantity_colon'             => __('Maximum Quantity:', 'wpamelia'),
            'description_colon'                  => __('Description:', 'wpamelia'),
            'category_colon'                     => __('Category:', 'wpamelia'),
            'capacity_colon'                     => __('Capacity:', 'wpamelia'),
            'weeks'                              => __('weeks', 'wpamelia'),
            'package_book_duration'              => __('The package is time-limited to', 'wpamelia'),
            'book_appointment'                   => __('Book Appointment', 'wpamelia'),
            'package_rules_description'          => __('Package rules and description', 'wpamelia'),
            'selected_services'                  => __('Selected services', 'wpamelia'),
            'manage_languages'                   => __('Manage languages', 'wpamelia'),
            'package_name'                       => __('Package Name', 'wpamelia'),
            'time_zone'                          => __('Time Zone', 'wpamelia'),
            'visibility'                         => __('Visibility', 'wpamelia'),
            'congratulations'                    => __('Congratulations!', 'wpamelia'),
            'booking_completed_approved'         => __('Thank you! Your booking is completed.', 'wpamelia'),
            'booking_completed_pending'          => __('Thank you! Your booking is completed and now is pending confirmation.', 'wpamelia'),
            'select_calendar'                    => __('Select Calendar', 'wpamelia'),
            'add_to_calendar'                    => __('Add to Calendar', 'wpamelia'),
            'finish_appointment'                 => __('Finish', 'wpamelia'),
            'form_colors'                        => __('Form colors', 'wpamelia'),
            'form_type_step_by_step'             => __('Step By Step Booking Form', 'wpamelia'),
            'form_type_event_list'               => __('Event List Booking Form', 'wpamelia'),
            'form_type_event_calendar'           => __('Event Calendar Booking Form', 'wpamelia'),
            'event_status'                       => __('Event Status', 'wpamelia'),
            'event_employee'                     => __('Event Employee', 'wpamelia'),
            'event_today'                        => __('Today', 'wpamelia'),
            'event_filters'                      => __('Filters', 'wpamelia'),
            'event_upcoming_events'              => __('Upcoming events', 'wpamelia'),
            'event_spot'                         => __('spot left', 'wpamelia'),
            'event_spots'                        => __('spots left', 'wpamelia'),
            'event_no_spots'                     => __('No spots left', 'wpamelia'),
            'event_book_now'                     => __('Book now', 'wpamelia'),
            'event_upcoming_empty'               => __('There are no upcoming events for this period', 'wpamelia'),
            'upcoming_events_block'              => __('Upcoming events block', 'wpamelia'),
            'event_capacity_block'               => __('Capacity', 'wpamelia'),
            'event_location_block'               => __('Location', 'wpamelia'),
            'event_price_block'                  => __('Price', 'wpamelia'),
            'event_range_block'                  => __('Date range', 'wpamelia'),
            'event_show_less'                    => __('Show less', 'wpamelia'),
            'event_schedule'                     => __('Schedule:', 'wpamelia'),
            'event_hosted_by'                    => __('Hosted by:', 'wpamelia'),
            'event_book_event'                   => __('Book event', 'wpamelia'),
            'event_many_people'                  => __('How many people are coming?', 'wpamelia'),
            'form_type_catalog'                  => __('Catalog Booking Form', 'wpamelia'),
            'form_block_service'                 => __('Service', 'wpamelia'),
            'form_block_package'                 => __('Package', 'wpamelia'),
            'form_block_catalog'                 => __('Catalog', 'wpamelia'),
            'form_block_catalog_service'         => __('Catalog Service', 'wpamelia'),
            'form_block_catalog_package'         => __('Catalog Package', 'wpamelia'),
            'form'                               => __('Form', 'wpamelia'),
            'form_flow'                          => __('Form Flow', 'wpamelia'),
            'show_single_event'                  => __('Show single Event details on the page', 'wpamelia'),
            'window_vue_tooltip'                 => __('This setting is used to load plugin\'s Vue JS<br>primarily when there is another plugin that uses Vue JS.<br>It reduces the possibility of conflict on the Front-end employee and customer panels.', 'wpamelia'),
            'payment_type_deposit_only'          => __('Deposit only', 'wpamelia'),
            'payment_type_full_amount'           => __('Whole amount', 'wpamelia'),
            'custom'                             => __('Custom', 'wpamelia'),
            'font_url'                           => __('Font URL', 'wpamelia'),
            'font_family'                        => __('Font Family', 'wpamelia'),
            'use_global_colors'                  => __('Use Global Colors', 'wpamelia'),
        ];
    }

    /**
     * @return array
     */
    public static function getWordPressStrings()
    {
        return [
            'booking'                          => __('Booking', 'wpamelia'),
            'catalog'                          => __('Catalog', 'wpamelia'),
            'choose_category'                  => __('Choose Category', 'wpamelia'),
            'choose_service'                   => __('Choose Service', 'wpamelia'),
            'choose_package'                   => __('Choose Package', 'wpamelia'),
            'filter'                           => __('Preselect Booking Parameters', 'wpamelia'),
            'insert_amelia_shortcode'          => __('Insert Amelia Booking Shortcode', 'wpamelia'),
            'notice_panel'                     => __('Notice: Please select at least one panel.', 'wpamelia'),
            'search'                           => __('Search', 'wpamelia'),
            'search_date'                      => __('Preselect Current Date', 'wpamelia'),
            'select_catalog_view'              => __('Select Catalog View', 'wpamelia'),
            'select_package'                   => __('Select Package', 'wpamelia'),
            'select_category'                  => __('Select Category', 'wpamelia'),
            'select_employee'                  => __('Select Employee', 'wpamelia'),
            'select_location'                  => __('Select Location', 'wpamelia'),
            'select_service'                   => __('Select Service', 'wpamelia'),
            'select_event'                     => __('Select Event', 'wpamelia'),
            'select_tag'                       => __('Select Tag', 'wpamelia'),
            'select_view'                      => __('Select View', 'wpamelia'),
            'show'                             => __('Show', 'wpamelia'),
            'show_all'                         => __('Show All', 'wpamelia'),
            'manually_loading'                 => __('Load booking form manually', 'wpamelia'),
            'manually_loading_description'     => __('Add element (button, link...) ID, that will manually load amelia shortcode content', 'wpamelia'),
            'show_all_categories'              => __('Show all categories', 'wpamelia'),
            'show_all_employees'               => __('Show all employees', 'wpamelia'),
            'show_all_locations'               => __('Show all locations', 'wpamelia'),
            'show_all_services'                => __('Show all services', 'wpamelia'),
            'show_all_events'                  => __('Show all events', 'wpamelia'),
            'show_all_tags'                    => __('Show all tags', 'wpamelia'),
            'show_catalog'                     => __('Show catalog of all categories', 'wpamelia'),
            'show_category'                    => __('Show specific category', 'wpamelia'),
            'show_package'                     => __('Show specific package', 'wpamelia'),
            'show_event'                       => __('Show event', 'wpamelia'),
            'show_event_view_type'             => __('Show Type', 'wpamelia'),
            'show_event_view_list'             => __('List (default)', 'wpamelia'),
            'show_event_view_calendar'         => __('Calendar', 'wpamelia'),
            'show_tag'                         => __('Show tag', 'wpamelia'),
            'show_service'                     => __('Show specific service', 'wpamelia'),
            'recurring_event'                  => __('Show recurring events', 'wpamelia'),
            'search_divi'                      => __('AM - Search view', 'wpamelia'),
            'booking_divi'                     => __('AM - Booking view', 'wpamelia'),
            'catalog_divi'                     => __('AM - Catalog view', 'wpamelia'),
            'events_divi'                      => __('AM - Events view', 'wpamelia'),
            'customer_cabinet_divi'            => __('AM - Customer Panel', 'wpamelia'),
            'employee_cabinet_divi'            => __('AM - Employee Panel', 'wpamelia'),
            'search_gutenberg_block'           => [
                'title'       => __('Amelia - Search view', 'wpamelia'),
                'description' => __('Front-end Booking Search is shortcode that give your customers the possibility to search for appointment by selecting several filters so that they could find the best time slots and services for their needs.', 'wpamelia'),
            ],
            'booking_gutenberg_block'          => [
                'title'       => __('Amelia - Booking view', 'wpamelia'),
                'description' => __('Step-By-Step Booking Wizard gives your customers the option to choose everything about the booking in a few steps', 'wpamelia'),
            ],
            'catalog_gutenberg_block'          => [
                'title'       => __('Amelia - Catalog view', 'wpamelia'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a cataloge', 'wpamelia'),
            ],
            'events_gutenberg_block'           => [
                'title'       => __('Amelia - Events', 'wpamelia'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'wpamelia'),
            ],
            'customer_cabinet_gutenberg_block' => [
                'title'       => __('Amelia - Customer Panel', 'wpamelia'),
                'description' => __('Front-end Customer Panel is a shortcode that gives your customers the possibility to manage their bookings and profile information.', 'wpamelia'),
            ],
            'employee_cabinet_gutenberg_block' => [
                'title'       => __('Amelia - Employee Panel', 'wpamelia'),
                'description' => __('Front-end Employee Panel is a shortcode that gives your employees the possibility to manage their bookings, working hours, days off, assigned services and profile information.', 'wpamelia'),
            ],
        ];
    }

    /**
     * @return array
     */
    public static function getBuddyBossStrings()
    {
        return [
            'amelia_settings_profile'           => __('Amelia Profile Settings', 'wpamelia'),
            'amelia_settings_customers'         => __('Amelia Users Settings', 'wpamelia'),
            'enable_amelia'                     => __('Enable Amelia', 'wpamelia'),
            'enable_booking_tab'                => __('Enable Amelia Tabs on Profiles', 'wpamelia'),
            'booking_form_enabled'              => __('Booking form on customer profile enabled', 'wpamelia'),
            'bookingform_enabled'               => __('Booking form tab enabled', 'wpamelia'),
            'booking_form_employee_enabled'     => __('Booking form on employee profile enabled', 'wpamelia'),
            'booking_form_type'                 => __('Booking form type', 'wpamelia'),
            'booking_form_type_employee'        => __('Booking form type on employee profile page', 'wpamelia'),
            'booking_tab_name'                  => __('Booking tab name', 'wpamelia'),
            'book_subtab_name'                  => __('Book subtab name', 'wpamelia'),
            'panel_subtab_name'                 => __('Panel subtab name', 'wpamelia'),
            'booking_employee_tab_name'         => __('Booking on employee page tab name', 'wpamelia'),
            'booking_form_events_list'          => __('Events List', 'wpamelia'),
            'booking_form_events_calendar'      => __('Events Calendar', 'wpamelia'),
            'subscribers_transform'             => __('Transform Subscribers to Amelia Customers', 'wpamelia'),
            'subscribers_transform_text'        => __('Every user with the role of subscriber will have the role of Amelia Customer added', 'wpamelia'),
            'create_customers_text'             => __('Create Customers from WP Users with Amelia Customer Role', 'wpamelia'),
            'create_providers_text'             => __('Create Employees from WP Users with Amelia Employee Role', 'wpamelia'),
            'create_customers'                  => __('Create Amelia Customers', 'wpamelia'),
            'create_providers'                  => __('Create Amelia Employees', 'wpamelia'),
        ];
    }

    /**
     * @return array
     */
    public static function getRecurringStrings()
    {
        return [
            'recurring_appointments'   => __('Recurring Appointments', 'wpamelia'),
            'recurring_sub_message1'   => __('Some of the desired slots are busy. We offered you the nearest time slots instead.', 'wpamelia'),
            'recurring_sub_message2'   => __('Number of adjusted time slots: ', 'wpamelia'),
            'recurring_active'         => __('Repeat this appointment', 'wpamelia'),
            'recurring_active_tooltip' => __('Check this option if you want to create recurring appointments', 'wpamelia'),
            'recurring_type_daily'     => __('Daily', 'wpamelia'),
            'recurring_type_weekly'    => __('Weekly', 'wpamelia'),
            'recurring_type_monthly'   => __('Monthly', 'wpamelia'),
            'recurring_repeat'         => __('Repeat:', 'wpamelia'),
            'recurring_every'          => __('Every:', 'wpamelia'),
            'recurring_until'          => __('Until:', 'wpamelia'),
            'recurring_every_text'     => __('Every', 'wpamelia'),
            'recurring_until_text'     => __('until', 'wpamelia'),
            'recurring_on'             => __('On:', 'wpamelia'),
            'recurring_each'           => __('Each:', 'wpamelia'),
            'recurring_times'          => __('Time(s):', 'wpamelia'),
            'recurring_date_specific'  => __('Specific Date', 'wpamelia'),
            'recurring_date_first'     => __('First', 'wpamelia'),
            'recurring_date_second'    => __('Second', 'wpamelia'),
            'recurring_date_third'     => __('Third', 'wpamelia'),
            'recurring_date_fourth'    => __('Fourth', 'wpamelia'),
            'recurring_date_last'      => __('Last', 'wpamelia'),
        ];
    }
}
